/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.editors.dnd;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.common.model.ui.editors.dnd.DropData;
import org.jboss.tools.common.model.ui.editors.dnd.IDropWizardModel;
import org.jboss.tools.common.model.ui.editors.dnd.ITagProposal;
import org.jboss.tools.common.model.ui.editors.dnd.ITagProposalFactory;
import org.jboss.tools.common.model.ui.editors.dnd.composite.TagAttributesComposite;
import org.jboss.tools.common.model.ui.editors.dnd.composite.TagProposalsComposite;

public class DefaultDropWizardModel
implements IDropWizardModel {
    ITagProposal fSelectedTagProp = UNDEFINED_TAG_PROPOSAL;
    DropData fDropData;
    List<TagAttributesComposite.AttributeDescriptorValue> fAttributeValues = new ArrayList<TagAttributesComposite.AttributeDescriptorValue>();
    boolean promptForTagAttributes = true;
    ITagProposalFactory tagProposalFactory;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public DefaultDropWizardModel(ITagProposalFactory tagProposalFactory) {
        this.tagProposalFactory = tagProposalFactory;
    }

    public ITagProposal getTagProposal() {
        return this.fSelectedTagProp;
    }

    public void setTagProposal(ITagProposal selection) {
        ITagProposal oldValue = this.fSelectedTagProp;
        this.fSelectedTagProp = selection;
        this.doLoadTagAttributeDescriptors();
        this.doLoadDefaultAttributeValues();
        this.fireModelChaged("tagProposal", oldValue, this.fSelectedTagProp);
    }

    public void setAttributeValue(TagAttributesComposite.AttributeDescriptorValue descrValue, Object value) {
        descrValue.setValue(value);
        this.fireModelChaged("attributeValue", null, descrValue);
    }

    public void setAttributeValue(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        TagAttributesComposite.AttributeDescriptorValue descrValue = this.findDescriptor(name);
        if (descrValue == null) {
            throw new IllegalArgumentException("Attribute '" + name + "' not found");
        }
        descrValue.setValue(value);
        this.fireModelChaged("attributeValue", null, descrValue);
    }

    public void setPreferable(String name) {
        if (name == null) {
            return;
        }
        TagAttributesComposite.AttributeDescriptorValue descrValue = this.findDescriptor(name);
        if (descrValue != null) {
            descrValue.setPreferable(true);
        }
    }

    private TagAttributesComposite.AttributeDescriptorValue findDescriptor(String name) {
        int i = 0;
        while (i < this.fAttributeValues.size()) {
            TagAttributesComposite.AttributeDescriptorValue arrayElement = this.fAttributeValues.get(i);
            if (name.equals(arrayElement.getName())) {
                return arrayElement;
            }
            ++i;
        }
        return null;
    }

    public List getAttributeNameList() {
        return null;
    }

    public String getAttributeValue(String name) {
        return null;
    }

    public void setDropData(DropData data) {
        this.fDropData = data;
    }

    public DropData getDropData() {
        return this.fDropData;
    }

    public TagAttributesComposite.AttributeDescriptorValue[] getAttributeValueDescriptors() {
        return this.fAttributeValues.toArray(new TagAttributesComposite.AttributeDescriptorValue[this.fAttributeValues.size()]);
    }

    private void doLoadDefaultAttributeValues() {
        this.getTagProposal().getAttributesValueLoader().fillTagAttributes(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    private void fireModelChaged(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void doLoadTagAttributeDescriptors() {
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public boolean isWizardRequired() {
        ITagProposal[] proposals;
        if (this.getTagProposal() != UNDEFINED_TAG_PROPOSAL && this.getAttributeValueDescriptors().length == 0) {
            return false;
        }
        if (this.getTagProposal() != UNDEFINED_TAG_PROPOSAL && this.getAttributeValueDescriptors().length > 0) {
            TagAttributesComposite.AttributeDescriptorValue[] values = this.getAttributeValueDescriptors();
            int i = 0;
            while (i < values.length) {
                TagAttributesComposite.AttributeDescriptorValue element = values[i];
                if (element.isPreferable() || element.isRequired()) {
                    return true;
                }
                ++i;
            }
            return this.isPromptForTagAttributesRequired();
        }
        return this.getTagProposal() == UNDEFINED_TAG_PROPOSAL && (proposals = TagProposalsComposite.getTagProposals(this.getDropData().getMimeType(), this.getDropData(), this.tagProposalFactory)).length > 1;
    }

    public boolean isValid() {
        return this.getTagProposal() != IDropWizardModel.UNDEFINED_TAG_PROPOSAL;
    }

    public ITagProposalFactory getTagProposalFactory() {
        return this.tagProposalFactory;
    }

    public boolean isPromptForTagAttributesRequired() {
        return this.promptForTagAttributes;
    }

    public void setPromptForTagAttributesRequired(boolean prompt) {
        this.promptForTagAttributes = prompt;
    }
}

