/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.jboss.tools.jst.jsp.util.NodesManagingUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.editor.selection.VpeSelectionController;
import org.jboss.tools.vpe.editor.util.TextUtil;
import org.jboss.tools.vpe.editor.util.VpeNodesManagingUtil;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMRange;
import org.mozilla.interfaces.nsISelection;
import org.w3c.dom.Node;

public class SelectionUtil {
    public static nsIDOMNode getSelectedNode(nsISelection selection) {
        nsIDOMNode selectedNode = null;
        nsIDOMNode focusNode = selection.getFocusNode();
        if (selection.getAnchorNode() == focusNode) {
            if (focusNode != null) {
                selectedNode = focusNode.getNodeType() != 3 && selection.getFocusOffset() != 0 ? focusNode.getChildNodes().item((long)(selection.getFocusOffset() - 1)) : selection.getFocusNode();
            }
        } else {
            nsIDOMRange range = selection.getRangeAt(0);
            selectedNode = range.getCommonAncestorContainer();
        }
        return selectedNode;
    }

    public static void setSourceSelection(VpePageContext pageContext, Node node) {
        int start = NodesManagingUtil.getStartOffsetNode((Node)node);
        int length = NodesManagingUtil.getNodeLength((Node)node);
        pageContext.getSourceBuilder().getStructuredTextViewer().setSelectedRange(start, length);
        pageContext.getSourceBuilder().getStructuredTextViewer().revealRange(start, length);
    }

    public static void setSourceSelection(VpePageContext pageContext, Node node, int offset, int length) {
        int start = NodesManagingUtil.getStartOffsetNode((Node)node);
        SelectionUtil.setSourceSelection(pageContext, start + offset, length);
    }

    public static void setSourceSelection(VpePageContext pageContext, Node node, int offset) {
        int start = NodesManagingUtil.getStartOffsetNode((Node)node);
        pageContext.getSourceBuilder().getStructuredTextViewer().getTextWidget().setSelection(start + offset);
    }

    public static void setSourceSelection(VpePageContext pageContext, int offset, int length) {
        pageContext.getSourceBuilder().getStructuredTextViewer().setSelectedRange(offset, length);
        pageContext.getSourceBuilder().getStructuredTextViewer().revealRange(offset, length);
    }

    public static VpeNodeMapping getNodeMappingBySourceSelection(IStructuredModel model, VpeDomMapping domMapping, int focus, int anchor) {
        Node focusNode;
        if (anchor < focus) {
            int tmp = focus;
            focus = anchor;
            anchor = tmp;
        }
        if ((focusNode = SelectionUtil.getSourceNodeByPosition(model, focus)) != null && NodesManagingUtil.isNodeContainsPosition((Node)focusNode, (int)anchor)) {
            return VpeNodesManagingUtil.getNodeMapping(domMapping, focusNode);
        }
        return null;
    }

    private static Node getSourceNodeByPosition(IStructuredModel model, int position) {
        IndexedRegion possibleNode;
        IndexedRegion node = model.getIndexedRegion(position);
        IndexedRegion indexedRegion = possibleNode = position >= 1 ? model.getIndexedRegion(position - 1) : null;
        if (node == null && position >= 1) {
            node = possibleNode;
        } else if (node != null && ((Node)node).getNodeType() != 3 && node.getStartOffset() == position && position >= 1) {
            node = possibleNode;
        } else if (node != null && ((Node)node).getNodeType() != 3 && possibleNode != null && ((Node)possibleNode).getNodeType() == 3) {
            node = possibleNode;
        }
        return (Node)node;
    }

    public static Point getVisualSelectionRange(nsISelection selection) {
        Point range = new Point(0, 0);
        nsIDOMNode focusedNode = SelectionUtil.getSelectedNode(selection);
        if (focusedNode != null) {
            range.x = selection.getFocusOffset();
            range.y = selection.getAnchorOffset() - selection.getFocusOffset();
        }
        return range;
    }

    public static Point getSourceSelectionRange(nsISelection selection, Node sourceNode) {
        nsIDOMNode focusedNode = SelectionUtil.getSelectedNode(selection);
        Point sourceRange = new Point(0, 0);
        if (sourceNode != null && sourceNode.getNodeValue() != null) {
            NodeImpl nodeImpl = (NodeImpl)sourceNode;
            sourceRange.x = TextUtil.sourcePosition(nodeImpl.getValueSource(), focusedNode.getNodeValue(), selection.getFocusOffset());
            sourceRange.y = TextUtil.sourcePosition(nodeImpl.getValueSource(), focusedNode.getNodeValue(), selection.getAnchorOffset()) - sourceRange.x;
        }
        return sourceRange;
    }

    public static VpeNodeMapping getNodeMappingBySourceSelection(StructuredTextEditor sourceEditor, VpeDomMapping domMapping) {
        Point range = sourceEditor.getTextViewer().getSelectedRange();
        IDocument document = sourceEditor.getTextViewer().getDocument();
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (model == null) {
                return null;
            }
            int anchor = range.x;
            int focus = range.x + range.y;
            Node focusNode = null;
            if (anchor < focus) {
                int tmp = focus;
                focus = anchor;
                anchor = tmp;
            }
            if (anchor == focus) {
                focusNode = SelectionUtil.getSourceNodeByPosition(model, focus);
            } else {
                IndexedRegion node = model.getIndexedRegion(focus);
                if (node != null) {
                    focusNode = (Node)node;
                }
            }
            if (focusNode != null) {
                VpeNodeMapping vpeNodeMapping = VpeNodesManagingUtil.getNodeMapping(domMapping, focusNode);
                return vpeNodeMapping;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return null;
    }

    public static Node getNodeBySourcePosition(StructuredTextEditor sourceEditor, int position) {
        IDocument document = sourceEditor.getTextViewer().getDocument();
        IStructuredModel model = null;
        Node node = null;
        try {
            model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            node = (Node)model.getIndexedRegion(position);
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return node;
    }

    public static nsIDOMNode getLastSelectedNode(VpePageContext pageContext) {
        return pageContext.getVisualBuilder().getXulRunnerEditor().getLastSelectedNode();
    }

    public static Point getSourceSelectionRange(StructuredTextEditor sourceEditor) {
        StructuredTextViewer textViewer = sourceEditor.getTextViewer();
        if (textViewer != null) {
            return textViewer.getSelectedRange();
        }
        return null;
    }

    public static void clearSelection(VpeSelectionController selectionController) {
        selectionController.getSelection((short)1).removeAllRanges();
    }
}

