/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.toolbar.format;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolItem;
import org.jboss.tools.vpe.editor.template.textformating.FormatAttributeData;
import org.jboss.tools.vpe.editor.toolbar.format.FormatControllerManager;
import org.jboss.tools.vpe.editor.toolbar.format.ToolItemFormatController;
import org.w3c.dom.Attr;

public abstract class ColorFormatController
extends ToolItemFormatController {
    protected String color;

    public ColorFormatController(FormatControllerManager manager, ToolItem toolItem) {
        super(manager, toolItem);
    }

    @Override
    public void handleEvent(Event event) {
        ColorDialog cd = new ColorDialog(this.toolItem.getParent().getShell(), 65536);
        cd.setText(this.getColorDialogTitle());
        cd.setRGB(new RGB(255, 255, 255));
        RGB newColor = cd.open();
        if (newColor == null) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        String c = Integer.toHexString(newColor.red);
        if (c.length() < 2) {
            buf.append("0");
        }
        buf.append(c);
        c = Integer.toHexString(newColor.green);
        if (c.length() < 2) {
            buf.append("0");
        }
        buf.append(c);
        c = Integer.toHexString(newColor.blue);
        if (c.length() < 2) {
            buf.append("0");
        }
        buf.append(c);
        this.color = buf.toString();
        super.handleEvent(event);
    }

    protected abstract String getColorDialogTitle();

    protected String createStylePropertyValue() {
        if (this.color != null && this.color.trim().length() > 0) {
            return "#" + this.color;
        }
        return null;
    }

    @Override
    public void setToolbarItemSelection() {
    }

    @Override
    protected boolean isStyleSet(Attr attribute, FormatAttributeData templateData) {
        return false;
    }
}

