/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAnyData;
import org.jboss.tools.vpe.editor.template.VpeHtmlTemplate;
import org.jboss.tools.vpe.editor.template.VpeRenderingTemplate;
import org.jboss.tools.vpe.editor.template.VpeTemplate;
import org.jboss.tools.vpe.editor.template.VpeTemplateConditionSet;
import org.jboss.tools.vpe.editor.template.VpeTemplateFile;
import org.jboss.tools.vpe.editor.template.VpeTemplateFileList;
import org.jboss.tools.vpe.editor.template.VpeTemplateListener;
import org.jboss.tools.vpe.editor.template.VpeTemplateSet;
import org.jboss.tools.vpe.editor.template.custom.CustomTLDReference;
import org.jboss.tools.vpe.editor.template.textformating.TextFormatingData;
import org.jboss.tools.vpe.editor.util.SourceDomUtil;
import org.jboss.tools.vpe.editor.util.XmlUtil;
import org.osgi.framework.Bundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VpeTemplateManager {
    private static final String EMPTY_VPE_TEMPLATES_AUTO = "templates/empty-vpe-templates-auto.xml";
    private static final String VPE_TEMPLATES_AUTO = "templates/vpe-templates-auto.xml";
    static final String TEMPLATES_FOLDER = String.valueOf(File.separator) + "templates" + File.separator;
    public static final String VPE_PREFIX = "vpe:";
    public static final String TAG_TEMPLATES = "vpe:templates";
    static final String TAG_LIST = "vpe:list";
    static final String ATTR_LIST_ORDERED = "ordered";
    static final String[] ATTR_LIST_PROPERTIES = new String[]{"ordered", "style", "class", "title", "lang", "dir"};
    static final String TAG_LABELED_FORM = "vpe:labeledForm";
    static final String ATTR_LABELED_FORM_LABEL = "labelName";
    static final String ATTR_LABELED_FORM_DEFAULT_LABEL = "label";
    static final String[] ATTR_LABELED_FORM_PROPERTIES = new String[]{"style", "class", "width", "border", "frame", "rules", "cellspacing", "cellpadding", "bgcolor", "title"};
    static final String TAG_TEMPLATES_LIST = "vpe:templates-list";
    static final String TAG_TEMPLATE_TAGLIB = "vpe:template-taglib";
    static final String TAG_TAG = "vpe:tag";
    static final String TAG_IF = "vpe:if";
    static final String TAG_TEMPLATE = "vpe:template";
    static final String TAG_COPY = "vpe:copy";
    static final String TAG_GRID = "vpe:grid";
    static final String TAG_PANELGRID = "vpe:panelgrid";
    static final String TAG_ELEMENT = "vpe:element";
    static final String TAG_ATTRIBUTE = "vpe:attribute";
    static final String TAG_VALUE = "vpe:value";
    static final String TAG_XMLNS = "vpe:xmlns";
    static final String TAG_ANY = "vpe:any";
    static final String TAG_TAGLIB = "vpe:taglib";
    static final String TAG_LINK = "vpe:link";
    static final String TAG_LOAD_BUNDLE = "vpe:load-bundle";
    static final String TAG_A = "vpe:a";
    static final String TAG_DATATABLE = "vpe:datatable";
    static final String TAG_DATATABLE_COLUMN = "vpe:column";
    static final String TAG_COMMENT = "vpe:comment";
    static final String TAG_STYLE = "vpe:style";
    static final String TAG_JSPROOT = "vpe:jsproot";
    static final String TAG_RESIZE = "vpe:resize";
    static final String TAG_DND = "vpe:dnd";
    static final String TAG_FACET = "vpe:facet";
    static final String TAG_MY_FACES_PAGE_LAYOUT = "vpe:panellayout";
    public static final String TAG_TEXT_FORMATING = "vpe:textFormatting";
    public static final String TAG_FORMAT = "vpe:format";
    public static final String TAG_FORMAT_ATTRIBUTE = "vpe:formatAttribute";
    public static final String ATTR_FORMAT_TYPE = "type";
    public static final String ATTR_FORMAT_ADD_CHILDREN = "addChildren";
    public static final String ATTR_FORMAT_ADD_PARENT = "addParent";
    public static final String ATTR_FORMAT_ADD_CHILDREN_HANDLER = "addChildrenHandler";
    public static final String ATTR_FORMAT_HANDLER = "handler";
    public static final String ATTR_FORMAT_SET_DEFAULT = "setDefault";
    public static final String ATTR_FORMAT_ATTRIBUTE_TYPE = "type";
    public static final String ATTR_FORMAT_ATTRIBUTE_NAME = "name";
    public static final String ATTR_FORMAT_ATTRIBUTE_VALUE = "value";
    public static final String ATTR_FORMAT_ATTRIBUTE_CASE_SENSITIVE = "caseSensitive";
    public static final String ATTR_FORMAT_ATTRIBUTE_TRUE_VALUE = "true";
    public static final String ATTR_FORMAT_ADD_CHILDREN_ALLOW_VALUE = "allow";
    public static final String ATTR_FORMAT_ADD_CHILDREN_DENY_VALUE = "deny";
    public static final String ATTR_FORMAT_ADD_CHILDREN_ITSELF_VALUE = "itself";
    public static final String ATTR_FORMAT_ATTRIBUTE_TYPE_STYLE_VALUE = "style";
    static final String ATTR_DIRECTIVE_TAGLIB_URI = "uri";
    static final String ATTR_DIRECTIVE_TAGLIB_PREFIX = "prefix";
    static final String ATTR_TAG_NAME = "name";
    static final String ATTR_TAG_CASE_SENSITIVE = "case-sensitive";
    public static final String ATTR_VALUE_YES = "yes";
    static final String ATTR_VALUE_NO = "no";
    static final String ATTR_IF_TEST = "test";
    static final String ATTR_TEMPLATE_CLASS = "class";
    static final String ATTR_TEMPLATE_CHILDREN = "children";
    static final String ATTR_TEMPLATE_MODIFY = "modify";
    static final String ATTR_TEMPLATE_HAS_IMAGINARY_BORDER = "hasImaginaryBorder";
    static final String ATTR_TEMPLATE_INVISIBLE = "invisible";
    static final String ATTR_COPY_ATTRS = "attrs";
    static final String ATTR_ELEMENT_NAME = "name";
    static final String ATTR_ATTRIBUTE_NAME = "name";
    static final String ATTR_ATTRIBUTE_VALUE = "value";
    static final String ATTR_VALUE_EXPR = "expr";
    static final String ATTR_PANELGRID_TABLE_SIZE = "table-size";
    static final String ATTR_PANELGRID_HEADER_CLASS = "headerClass";
    static final String ATTR_PANELGRID_FOOTER_CLASS = "footerClass";
    static final String ATTR_PANELGRID_ROW_CLASSES = "rowClasses";
    static final String ATTR_PANELGRID_COLUMN_CLASSES = "columnClasses";
    static final String ATTR_PANELGRID_CAPTION_CLASS = "captionClass";
    static final String ATTR_PANELGRID_CAPTION_STYLE = "captionStyle";
    static final String ATTR_PANELGRID_RULES = "rules";
    static final String[] ATTR_PANELGRID_PROPERTIES = new String[]{"style", "class", "width", "border", "frame", "cellspacing", "cellpadding", "bgcolor", "title"};
    static final String ATTR_GRID_LAYOUT = "layout";
    static final String ATTR_GRID_TABLE_SIZE = "table-size";
    static final String[] ATTR_GRID_PROPERTIES = new String[]{"style", "class", "width", "border", "frame", "cellspacing", "cellpadding", "bgcolor", "title", "dir"};
    @Deprecated
    private static final String ATTR_ANY_DISPLAY = "display";
    static final String ATTR_ANY_TAG_FOR_DISPLAY = "tag-for-display";
    static final String ATTR_ANY_VALUE = "value";
    static final String ATTR_ANY_STYLE = "style";
    @Deprecated
    static final String ATTR_ANY_BORDER = "border";
    @Deprecated
    static final String ATTR_ANY_VALUE_COLOR = "value-color";
    @Deprecated
    static final String ATTR_ANY_VALUE_BACKGROUND_COLOR = "value-background-color";
    @Deprecated
    static final String ATTR_ANY_BACKGROUND_COLOR = "background-color";
    @Deprecated
    static final String ATTR_ANY_BORDER_COLOR = "border-color";
    static final String[] ATTR_ANY_PROPERTIES = new String[]{"title"};
    static final String ATTR_DATATABLE_HEADER_CLASS = "headerClass";
    static final String ATTR_DATATABLE_FOOTER_CLASS = "footerClass";
    static final String ATTR_DATATABLE_ROW_CLASSES = "rowClasses";
    static final String ATTR_DATATABLE_COLUMN_CLASSES = "columnClasses";
    static final String[] ATTR_DATATABLE_PROPERTIES = new String[]{"width", "height", "bgcolor", "border", "cellpadding", "cellspacing", "frame", "rules", "class", "style", "title", "dir", "rowClasses"};
    public static final String ATTR_LINK_HREF = "href";
    public static final String ATTR_LINK_REL = "rel";
    public static final String ATTR_LINK_EXT = "ext";
    static final String ATTR_TAG_MATCHING_MODE = "matching-mode";
    private static VpeTemplateManager instance = null;
    private static Object monitor = new Object();
    private Map<String, String> templateTaglibs = new HashMap<String, String>();
    private Map<String, VpeTemplateSet> caseSensitiveTags = new HashMap<String, VpeTemplateSet>();
    private Map<String, VpeTemplateSet> ignoreSensitiveTags = new HashMap<String, VpeTemplateSet>();
    private Map<String, VpeTemplateSet> docbookTags = new HashMap<String, VpeTemplateSet>();
    private Map<String, VpeTemplateSet> matchingTags = new HashMap<String, VpeTemplateSet>();
    private static final String ATTR_DOCBOOK_NAME = "docbook";
    private VpeTemplate defTemplate;
    private VpeTemplateListener[] templateListeners = new VpeTemplateListener[0];
    private VpeTemplateFileList templateFileList = new VpeTemplateFileList();
    private Set<String> withoutWhitespaceContainerSet = new HashSet<String>();
    private Set<String> withoutPseudoElementContainerSet = new HashSet<String>();
    private static final String TEXT_TEMPLATE_NAME = "#text";
    private static final String COMMENT_TEMPLATE_NAME = "#comment";
    private static final String ATTRIBUTE_TEMPLATE_NAME = "attribute";
    private static final String CUSTOM_TEMPLATE_NAME = "vpeCustomTemplate";
    private static final String JSF2_CUSTOM_TEMPLATE = "vpejsf2customTemplate";
    private static TextFormatingData defaultTextFormattingData;
    private static final String DEFAUL_TEXT_FORMATTING_CONF_FILE_NAME = "textFormatting.xml";
    public static final String ATTR_USE_DEFAULT_FORMATS = "use-default-formats";
    private static final String DOCBOOKEDITORID = "org.jboss.tools.jst.jsp.jspeditor.DocBookEditor";
    private static final String NAMESPACE_IDENTIFIER_ATTRIBUTE = "namespaceIdentifier";
    private static final IPath DEFAULT_AUTO_TEMPLATES_PATH;
    static String[] WITHOUT_WHITESPACE_ELEMENT_NAMES;

    static {
        DEFAULT_AUTO_TEMPLATES_PATH = VpePlugin.getDefault().getStateLocation().append(VPE_TEMPLATES_AUTO);
        WITHOUT_WHITESPACE_ELEMENT_NAMES = new String[]{"table", "caption", "col", "colgroup", "thead", "tbody", "tfoot", "th", "tr", "td"};
    }

    private VpeTemplateManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final VpeTemplateManager getInstance() {
        if (instance != null) {
            return instance;
        }
        Object object = monitor;
        synchronized (object) {
            if (instance == null) {
                VpeTemplateManager inst = new VpeTemplateManager();
                inst.load();
                instance = inst;
            }
        }
        return instance;
    }

    public VpeTemplate getTemplate(VpePageContext pageContext, Node sourceNode, Set<?> dependencySet) {
        VpeTemplate template = this.getTemplateImpl(pageContext, sourceNode, dependencySet);
        if (template != null) {
            return template;
        }
        return this.defTemplate;
    }

    private VpeTemplate getTemplateImpl(VpePageContext pageContext, Node sourceNode, Set<?> dependencySet) {
        if (sourceNode instanceof Element && SourceDomUtil.isRenderedAttrEqFalse(pageContext, (Element)sourceNode)) {
            return VpeRenderingTemplate.getInstance();
        }
        String name = this.getTemplateName(pageContext, sourceNode);
        if (name == null) {
            return null;
        }
        VpeTemplateSet set = null;
        if (DOCBOOKEDITORID.equals(pageContext.getEditPart().getSite().getId()) && (set = this.docbookTags.get(name)) != null) {
            return set.getTemplate(pageContext, sourceNode, dependencySet);
        }
        set = this.caseSensitiveTags.get(name);
        if (set != null) {
            return set.getTemplate(pageContext, sourceNode, dependencySet);
        }
        set = this.ignoreSensitiveTags.get(name.toLowerCase());
        if (set != null) {
            return set.getTemplate(pageContext, sourceNode, dependencySet);
        }
        if (this.matchingTags.entrySet() != null) {
            for (Map.Entry<String, VpeTemplateSet> entry : this.matchingTags.entrySet()) {
                if (!name.matches(entry.getKey()) || (set = entry.getValue()) == null) continue;
                return set.getTemplate(pageContext, sourceNode, dependencySet);
            }
        }
        return null;
    }

    public String getTemplateName(VpePageContext pageContext, Node sourceNode) {
        if (sourceNode == null) {
            return null;
        }
        switch (sourceNode.getNodeType()) {
            case 3: {
                return TEXT_TEMPLATE_NAME;
            }
            case 8: {
                return COMMENT_TEMPLATE_NAME;
            }
            case 2: {
                return ATTRIBUTE_TEMPLATE_NAME;
            }
            case 1: {
                String sourcePrefix = sourceNode.getPrefix();
                if (sourcePrefix == null) {
                    sourcePrefix = "";
                }
                if (((IDOMElement)sourceNode).isJSPTag() || "jsp".equals(sourcePrefix)) {
                    return sourceNode.getNodeName();
                }
                List<TaglibData> taglibs = XmlUtil.getTaglibsForNode(sourceNode, pageContext);
                TaglibData sourceNodeTaglib = XmlUtil.getTaglibForPrefix(sourcePrefix, taglibs);
                if (sourceNodeTaglib == null) {
                    return sourceNode.getLocalName();
                }
                String sourceNodeUri = sourceNodeTaglib.getUri();
                String templateTaglibPrefix = this.getTemplateTaglibPrefix(sourceNodeUri);
                if (templateTaglibPrefix != null) {
                    return String.valueOf(templateTaglibPrefix) + ":" + sourceNode.getLocalName();
                }
                if (sourceNodeUri != null && CustomTLDReference.isExistInCustomTlds(pageContext, sourceNodeUri)) {
                    return CUSTOM_TEMPLATE_NAME;
                }
                if (sourceNodeUri != null && CustomTLDReference.isExistInJsf2CustomComponenets(pageContext, sourceNodeUri, sourceNode.getLocalName())) {
                    return JSF2_CUSTOM_TEMPLATE;
                }
                return sourceNode.getNodeName();
            }
        }
        return null;
    }

    public String getTemplateTaglibPrefix(String sourceUri) {
        return this.templateTaglibs.get(sourceUri);
    }

    private void load() {
        this.initWithoutWhitespaceContainerSet();
        this.initPseudoElementContainerSet();
        this.templateFileList.load();
        this.loadImpl();
    }

    private void loadImpl() {
        VpeTemplateFile autoTemplateFile = this.templateFileList.getAutoTemplateFile();
        if (autoTemplateFile != null) {
            this.loadTemplates(autoTemplateFile.getPath(), autoTemplateFile.getConfigurableElement());
        }
        VpeTemplateFile[] templateFiles = this.templateFileList.getTemplateFiles();
        int i = 0;
        while (i < templateFiles.length) {
            this.loadTemplates(templateFiles[i].getPath(), templateFiles[i].getConfigurableElement());
            ++i;
        }
        if (this.defTemplate == null) {
            this.defTemplate = this.createDefTemplate();
        }
    }

    private void loadTemplates(IPath vpeFilePath, IConfigurationElement confElement) {
        Element root = XMLUtilities.getElement((File)vpeFilePath.toFile(), null);
        this.loadTemplates(root, confElement);
    }

    private void loadTemplates(Element root, IConfigurationElement confElement) {
        if (root == null || !TAG_TEMPLATES.equals(root.getNodeName())) {
            return;
        }
        NodeList children = root.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            int i = 0;
            while (i < len) {
                Node node = children.item(i);
                if (node.getNodeType() == 1) {
                    if (TAG_TAG.equals(node.getNodeName())) {
                        this.setTagElement((Element)node, confElement);
                    } else if (TAG_TEMPLATE.equals(node.getNodeName())) {
                        this.setDefTemplate(this.createTemplate((Element)node, confElement, true));
                    } else if (TAG_TEMPLATE_TAGLIB.equals(node.getNodeName())) {
                        this.setTemplateTaglib((Element)node);
                    }
                }
                ++i;
            }
        }
    }

    private void setTagElement(Element tagElement, IConfigurationElement confElement) {
        String name = tagElement.getAttribute("name");
        if (name.length() > 0) {
            Map<String, VpeTemplateSet> tags;
            boolean docbookTemplate = ATTR_VALUE_YES.equalsIgnoreCase(tagElement.getAttribute(ATTR_DOCBOOK_NAME));
            boolean caseSensitive = !ATTR_VALUE_NO.equals(tagElement.getAttribute(ATTR_TAG_CASE_SENSITIVE));
            boolean matchingMode = ATTR_VALUE_YES.equals(tagElement.getAttribute(ATTR_TAG_MATCHING_MODE));
            if (!matchingMode) {
                if (docbookTemplate) {
                    tags = this.docbookTags;
                } else if (caseSensitive) {
                    tags = this.caseSensitiveTags;
                } else {
                    name = name.toLowerCase();
                    tags = this.ignoreSensitiveTags;
                }
            } else {
                tags = this.matchingTags;
            }
            VpeTemplateSet set = tags.get(name);
            if (set == null) {
                set = new VpeTemplateSet();
                tags.put(name, set);
            }
            this.addChildren(tagElement, set, confElement, caseSensitive);
        }
    }

    private void addChildren(Element element, VpeTemplateSet set, IConfigurationElement confElement, boolean caseSensitive) {
        NodeList children = element.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            int i = 0;
            while (i < len) {
                Node node = children.item(i);
                if (node.getNodeType() == 1) {
                    if (TAG_IF.equals(node.getNodeName())) {
                        this.addIfElement((Element)node, set, confElement, caseSensitive);
                    } else if (TAG_TEMPLATE.equals(node.getNodeName())) {
                        set.setDefTemplate(this.createTemplate((Element)node, confElement, caseSensitive));
                    }
                }
                ++i;
            }
        }
    }

    private void addIfElement(Element ifElement, VpeTemplateSet parentSet, IConfigurationElement confElement, boolean caseSensitive) {
        String test = ifElement.getAttribute(ATTR_IF_TEST);
        VpeTemplateConditionSet set = new VpeTemplateConditionSet(test, caseSensitive);
        parentSet.addChild(set);
        this.addChildren(ifElement, set, confElement, caseSensitive);
    }

    public void setDefTemplate(VpeTemplate defTemplate) {
        if (this.defTemplate == null) {
            this.defTemplate = defTemplate;
        }
    }

    private void setTemplateTaglib(Element templateTaglibElement) {
        String uri = templateTaglibElement.getAttribute(ATTR_DIRECTIVE_TAGLIB_URI);
        String pefix = templateTaglibElement.getAttribute(ATTR_DIRECTIVE_TAGLIB_PREFIX);
        if (uri.length() > 0 && pefix.length() > 0 && !this.templateTaglibs.containsKey(uri)) {
            this.templateTaglibs.put(uri, pefix);
        }
    }

    public void setAnyTemplate(VpeAnyData data) {
        String elementName = data.getName();
        boolean caseSensitive = data.isCaseSensitive();
        Element root = this.loadAutoTemplate(DEFAULT_AUTO_TEMPLATES_PATH);
        if (root == null) {
            root = XMLUtilities.createDocumentElement((String)TAG_TEMPLATES);
        }
        HashSet<String> prefixSet = new HashSet<String>();
        Node tagElement = null;
        NodeList children = root.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            int i = len - 1;
            while (i >= 0) {
                Node node = children.item(i);
                if (node.getNodeType() == 1) {
                    if (TAG_TAG.equals(node.getNodeName())) {
                        if (caseSensitive == !ATTR_VALUE_NO.equals(((Element)node).getAttribute(ATTR_TAG_CASE_SENSITIVE))) {
                            String name = ((Element)node).getAttribute("name");
                            if (caseSensitive && name.equals(elementName) || !caseSensitive && name.equalsIgnoreCase(elementName)) {
                                tagElement = node;
                            }
                        }
                    } else if (TAG_TEMPLATE_TAGLIB.equals(node.getNodeName())) {
                        String prefix;
                        Node prefixAttr = node.getAttributes().getNamedItem(ATTR_DIRECTIVE_TAGLIB_PREFIX);
                        String string = prefix = prefixAttr != null ? prefixAttr.getNodeValue() : "";
                        if (prefix.length() > 0) {
                            prefixSet.add(prefix);
                        }
                    } else {
                        root.removeChild(node);
                    }
                }
                --i;
            }
        }
        Document document = root.getOwnerDocument();
        Element newTagElement = VpeTemplateManager.createNewTagElement(document, data);
        if (tagElement != null) {
            root.replaceChild(newTagElement, tagElement);
        } else {
            root.appendChild(newTagElement);
        }
        root = this.appendTaglib(prefixSet, document, root, data);
        try {
            IPath path = VpeTemplateManager.getAutoTemplates(DEFAULT_AUTO_TEMPLATES_PATH);
            XMLUtilities.serialize((Element)root, (String)path.toOSString());
        }
        catch (IOException e) {
            VpePlugin.reportProblem(e);
        }
        this.reload();
    }

    private Element appendTaglib(Set<?> prefixSet, Document document, Element root, VpeAnyData data) {
        if (data.getPrefix() != null && data.getUri() != null && data.getPrefix().length() > 0 && data.getUri().length() > 0 && !prefixSet.contains(data.getPrefix())) {
            Element node = this.createNewTaglibElement(document, data);
            Node firstNode = null;
            if (root.hasChildNodes()) {
                NodeList childs = root.getChildNodes();
                int i = 0;
                while (i < childs.getLength()) {
                    Node item = childs.item(i);
                    if (item.getNodeType() == 1) {
                        firstNode = item;
                        break;
                    }
                    ++i;
                }
            }
            if (firstNode != null) {
                root.insertBefore(node, firstNode);
            } else {
                root.appendChild(node);
            }
        }
        return root;
    }

    public List<VpeAnyData> getAnyTemplates() {
        return this.getAnyTemplates(DEFAULT_AUTO_TEMPLATES_PATH);
    }

    public List<VpeAnyData> getAnyTemplates(IPath path) {
        NodeList children;
        ArrayList<VpeAnyData> anyTemplateList = new ArrayList<VpeAnyData>();
        HashMap<String, Node> taglibs = new HashMap<String, Node>();
        Element root = this.loadAutoTemplate(path);
        if (root == null) {
            root = XMLUtilities.createDocumentElement((String)TAG_TEMPLATES);
        }
        if ((children = root.getChildNodes()) != null) {
            int len = children.getLength();
            int i = len - 1;
            while (i >= 0) {
                Node node = children.item(i);
                if (node.getNodeType() == 1) {
                    if (TAG_TAG.equals(node.getNodeName())) {
                        Attr attr = ((Element)node).getAttributeNode("name");
                        VpeAnyData anyData = new VpeAnyData(attr != null ? attr.getNodeValue() : "");
                        attr = ((Element)node).getAttributeNode(ATTR_TAG_CASE_SENSITIVE);
                        anyData.setCaseSensitive(ATTR_VALUE_YES.equalsIgnoreCase(attr.getNodeValue()));
                        Element templateNode = this.getChildNode(node, TAG_TEMPLATE);
                        if (templateNode != null) {
                            Element anyNode;
                            attr = templateNode.getAttributeNode(ATTR_TEMPLATE_CHILDREN);
                            if (attr != null) {
                                anyData.setChildren(ATTR_VALUE_YES.equalsIgnoreCase(attr.getNodeValue()));
                            }
                            if ((attr = templateNode.getAttributeNode(ATTR_TEMPLATE_MODIFY)) != null) {
                                anyData.setModify(ATTR_VALUE_YES.equalsIgnoreCase(attr.getNodeValue()));
                            }
                            if ((anyNode = this.getChildNode(templateNode, TAG_ANY)) != null) {
                                Attr attrBorderColor;
                                Attr attrBachkgroundColor;
                                Attr attrValueBackgroundColor;
                                Attr attrValueColor;
                                Attr attrBorder;
                                attr = anyNode.getAttributeNode(ATTR_ANY_TAG_FOR_DISPLAY);
                                if (attr != null) {
                                    anyData.setTagForDisplay(attr.getNodeValue());
                                }
                                if ((attr = anyNode.getAttributeNode(ATTR_TEMPLATE_CHILDREN)) != null) {
                                    anyData.setChildren(ATTR_VALUE_YES.equalsIgnoreCase(attr.getNodeValue()));
                                }
                                StringBuffer stringBuffer = new StringBuffer();
                                Attr attrDisplay = anyNode.getAttributeNode(ATTR_ANY_DISPLAY);
                                if (attr != null) {
                                    stringBuffer.append(ATTR_ANY_DISPLAY).append(":").append(attrDisplay.getNodeValue()).append(";");
                                }
                                if ((attr = anyNode.getAttributeNode("value")) != null) {
                                    anyData.setValue(attr.getNodeValue());
                                }
                                if ((attr = anyNode.getAttributeNode("style")) != null) {
                                    anyData.setStyle(attr.getNodeValue());
                                }
                                if ((attrBorder = anyNode.getAttributeNode(ATTR_ANY_BORDER)) != null) {
                                    stringBuffer.append("border-width:").append(attrBorder.getNodeValue()).append(";");
                                }
                                if ((attrValueColor = anyNode.getAttributeNode(ATTR_ANY_VALUE_COLOR)) != null) {
                                    stringBuffer.append("color:").append(attrValueColor.getNodeValue()).append(";");
                                }
                                if ((attrValueBackgroundColor = anyNode.getAttributeNode(ATTR_ANY_VALUE_BACKGROUND_COLOR)) != null) {
                                    stringBuffer.append("background-color:").append(attrValueBackgroundColor.getNodeValue()).append(";");
                                }
                                if ((attrBachkgroundColor = anyNode.getAttributeNode(ATTR_ANY_BACKGROUND_COLOR)) != null) {
                                    stringBuffer.append("background-color:").append(attrBachkgroundColor.getNodeValue()).append(";");
                                }
                                if ((attrBorderColor = anyNode.getAttributeNode(ATTR_ANY_BORDER_COLOR)) != null) {
                                    stringBuffer.append("border-color:").append(attrBorderColor.getNodeValue()).append(";");
                                }
                                if (stringBuffer.toString().length() > 0) {
                                    anyData.setStyle(stringBuffer.toString());
                                }
                            }
                        }
                        anyTemplateList.add(anyData);
                    } else if (TAG_TEMPLATE_TAGLIB.equals(node.getNodeName())) {
                        String prefix;
                        Node prefixAttr = node.getAttributes().getNamedItem(ATTR_DIRECTIVE_TAGLIB_PREFIX);
                        String string = prefix = prefixAttr != null ? prefixAttr.getNodeValue() : "";
                        if (prefix.length() > 0) {
                            taglibs.put(prefix, node);
                        }
                    }
                }
                --i;
            }
        }
        for (VpeAnyData element : anyTemplateList) {
            String prefix = element.getPrefix();
            if (!taglibs.containsKey(prefix)) continue;
            Node node = (Node)taglibs.get(prefix);
            Node uriAttr = node.getAttributes().getNamedItem(ATTR_DIRECTIVE_TAGLIB_URI);
            String uri = uriAttr != null ? uriAttr.getNodeValue() : "";
            element.setUri(uri);
        }
        return anyTemplateList;
    }

    private Element getChildNode(Node node, String childName) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            int i = 0;
            while (i < len) {
                Node item = children.item(i);
                if (item.getNodeType() == 1 && childName.equals(item.getNodeName())) {
                    return (Element)item;
                }
                ++i;
            }
        }
        return null;
    }

    public void setAnyTemplates(List<VpeAnyData> templates) {
        this.setAnyTemplates(templates, DEFAULT_AUTO_TEMPLATES_PATH);
    }

    public void setAnyTemplates(List<VpeAnyData> templates, IPath path) {
        if (templates != null) {
            HashSet<String> prefixSet = new HashSet<String>();
            Element root = XMLUtilities.createDocumentElement((String)TAG_TEMPLATES);
            Document document = root.getOwnerDocument();
            for (VpeAnyData data : templates) {
                root.appendChild(VpeTemplateManager.createNewTagElement(document, data));
                String prefix = data.getPrefix();
                if (prefix == null || prefix.length() <= 0 || prefixSet.contains(prefix)) continue;
                root = this.appendTaglib(prefixSet, document, root, data);
                prefixSet.add(prefix);
            }
            try {
                XMLUtilities.serialize((Element)root, (String)path.toOSString());
            }
            catch (IOException e) {
                VpePlugin.reportProblem(e);
            }
        }
    }

    public static Element createNewTagElement(Document document, VpeAnyData data) {
        Element newTagElement = document.createElement(TAG_TAG);
        newTagElement.setAttribute("name", data.getName());
        newTagElement.setAttribute(ATTR_TAG_CASE_SENSITIVE, data.isCaseSensitive() ? ATTR_VALUE_YES : ATTR_VALUE_NO);
        Element newTemplateElement = document.createElement(TAG_TEMPLATE);
        newTemplateElement.setAttribute(ATTR_TEMPLATE_CHILDREN, data.isChildren() ? ATTR_VALUE_YES : ATTR_VALUE_NO);
        newTemplateElement.setAttribute(ATTR_TEMPLATE_MODIFY, data.isModify() ? ATTR_VALUE_YES : ATTR_VALUE_NO);
        newTagElement.appendChild(newTemplateElement);
        Element newAnyElement = document.createElement(TAG_ANY);
        if (data.getTagForDisplay() != null && data.getTagForDisplay().length() > 0) {
            newAnyElement.setAttribute(ATTR_ANY_TAG_FOR_DISPLAY, data.getTagForDisplay());
        }
        if (data.getValue() != null && data.getValue().length() > 0) {
            newAnyElement.setAttribute("value", data.getValue());
        }
        if (data.getStyle() != null && data.getStyle().length() > 0) {
            newAnyElement.setAttribute("style", data.getStyle());
        }
        newTemplateElement.appendChild(newAnyElement);
        return newTagElement;
    }

    private Element createNewTaglibElement(Document document, VpeAnyData data) {
        Element newTaglibElement = document.createElement(TAG_TEMPLATE_TAGLIB);
        newTaglibElement.setAttribute(ATTR_DIRECTIVE_TAGLIB_PREFIX, data.getPrefix());
        newTaglibElement.setAttribute(ATTR_DIRECTIVE_TAGLIB_URI, data.getUri());
        return newTaglibElement;
    }

    private Element loadAutoTemplate(IPath path) {
        Element root = XMLUtilities.getElement((File)path.toFile(), null);
        if (root != null && TAG_TEMPLATES.equals(root.getNodeName())) {
            return root;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Object object = monitor;
        synchronized (object) {
            this.templateFileList.load();
            if (this.templateFileList.isChanged()) {
                this.caseSensitiveTags.clear();
                this.ignoreSensitiveTags.clear();
                this.matchingTags.clear();
                this.docbookTags.clear();
                this.defTemplate = null;
                this.loadImpl();
                this.fireTemplateReloaded();
            }
        }
    }

    public void addTemplateListener(VpeTemplateListener listener) {
        if (listener != null) {
            VpeTemplateListener[] newTemplateListeners = new VpeTemplateListener[this.templateListeners.length + 1];
            System.arraycopy(this.templateListeners, 0, newTemplateListeners, 0, this.templateListeners.length);
            this.templateListeners = newTemplateListeners;
            this.templateListeners[this.templateListeners.length - 1] = listener;
        }
    }

    public void removeTemplateListener(VpeTemplateListener listener) {
        if (listener == null || this.templateListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.templateListeners.length) {
            if (listener == this.templateListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.templateListeners.length == 1) {
            this.templateListeners = new VpeTemplateListener[0];
            return;
        }
        VpeTemplateListener[] newTemplateListeners = new VpeTemplateListener[this.templateListeners.length - 1];
        System.arraycopy(this.templateListeners, 0, newTemplateListeners, 0, index);
        System.arraycopy(this.templateListeners, index + 1, newTemplateListeners, index, this.templateListeners.length - index - 1);
        this.templateListeners = newTemplateListeners;
    }

    private void fireTemplateReloaded() {
        int i = 0;
        while (i < this.templateListeners.length) {
            this.templateListeners[i].templateReloaded();
            ++i;
        }
    }

    private Element createDefTemplateElement() {
        Element newTemplateElement = XMLUtilities.createDocumentElement((String)TAG_TEMPLATE);
        newTemplateElement.setAttribute(ATTR_TEMPLATE_CHILDREN, ATTR_VALUE_YES);
        newTemplateElement.setAttribute(ATTR_TEMPLATE_MODIFY, ATTR_VALUE_NO);
        Document document = newTemplateElement.getOwnerDocument();
        Element newAnyElement = document.createElement(TAG_ANY);
        newAnyElement.setAttribute("value", "{name()}");
        newAnyElement.setAttribute("title", "{tagstring()}");
        newTemplateElement.appendChild(newAnyElement);
        return newTemplateElement;
    }

    private void initWithoutWhitespaceContainerSet() {
        int i = 0;
        while (i < WITHOUT_WHITESPACE_ELEMENT_NAMES.length) {
            this.withoutWhitespaceContainerSet.add(WITHOUT_WHITESPACE_ELEMENT_NAMES[i]);
            ++i;
        }
    }

    private void initPseudoElementContainerSet() {
        this.withoutPseudoElementContainerSet.add("br");
        this.withoutPseudoElementContainerSet.add("input");
    }

    public boolean isWithoutWhitespaceContainer(String name) {
        return this.withoutWhitespaceContainerSet.contains(name.toLowerCase());
    }

    public boolean isWithoutPseudoElementContainer(String name) {
        return this.withoutPseudoElementContainerSet.contains(name.toLowerCase());
    }

    private VpeTemplate createTemplate(Element templateElement, IConfigurationElement confElement, boolean caseSensitive) {
        VpeTemplate template = null;
        String templateClassName = templateElement.getAttribute(ATTR_TEMPLATE_CLASS);
        String nameSpaceIdentifyer = templateElement.getAttribute(NAMESPACE_IDENTIFIER_ATTRIBUTE);
        if (templateClassName != null && templateClassName.length() > 0) {
            Bundle bundle;
            if (nameSpaceIdentifyer == null || nameSpaceIdentifyer.length() == 0) {
                nameSpaceIdentifyer = confElement.getNamespaceIdentifier();
            }
            if ((bundle = Platform.getBundle((String)nameSpaceIdentifyer)) == null) {
                template = null;
            } else {
                try {
                    Class templateClass = bundle.loadClass(templateClassName);
                    template = (VpeTemplate)templateClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    template = this.handleTemplateClassLoadException(template, templateClassName, nameSpaceIdentifyer, e);
                }
                catch (IllegalAccessException e) {
                    template = this.handleTemplateClassLoadException(template, templateClassName, nameSpaceIdentifyer, e);
                }
                catch (InstantiationException e) {
                    template = this.handleTemplateClassLoadException(template, templateClassName, nameSpaceIdentifyer, e);
                }
            }
        } else {
            template = new VpeHtmlTemplate();
        }
        if (template != null) {
            template.init(templateElement, caseSensitive);
        }
        return template;
    }

    private VpeTemplate handleTemplateClassLoadException(VpeTemplate template, String templateClassName, String nameSpaceIdentifyer, Exception e) {
        Class<?> templateClass = null;
        try {
            templateClass = Class.forName(templateClassName);
        }
        catch (ClassNotFoundException e1) {
            this.handleTemplateLoadException(templateClassName, nameSpaceIdentifyer, e1);
        }
        try {
            if (templateClass != null) {
                template = (VpeTemplate)templateClass.newInstance();
            }
        }
        catch (InstantiationException e2) {
            this.handleTemplateLoadException(templateClassName, nameSpaceIdentifyer, e2);
        }
        catch (IllegalAccessException e3) {
            this.handleTemplateLoadException(templateClassName, nameSpaceIdentifyer, e3);
        }
        return template;
    }

    private void handleTemplateLoadException(String templateClassName, String nameSpaceIdentifyer, Exception e) {
        String message = e.getMessage();
        if (message == null) {
            message = "Can't get VPE template class: " + templateClassName + ", from bundle:" + nameSpaceIdentifyer;
        }
        VpePlugin.getPluginLog().logError(message, (Throwable)e);
    }

    private VpeTemplate createDefTemplate() {
        VpeHtmlTemplate localDefTemplate = new VpeHtmlTemplate();
        localDefTemplate.init(this.createDefTemplateElement(), true);
        return localDefTemplate;
    }

    public VpeTemplate getDefTemplate() {
        if (this.defTemplate == null) {
            this.defTemplate = this.createDefTemplate();
        }
        return this.defTemplate;
    }

    public static TextFormatingData getDefaultTextFormattingData() {
        if (defaultTextFormattingData == null) {
            try {
                InputStream is = VpePlugin.getDefault().getBundle().getResource(DEFAUL_TEXT_FORMATTING_CONF_FILE_NAME).openStream();
                Element root = XMLUtilities.getElement((Reader)new InputStreamReader(is), null);
                defaultTextFormattingData = new TextFormatingData(root);
            }
            catch (IOException e) {
                VpePlugin.getPluginLog().logError((Throwable)e);
            }
        }
        return defaultTextFormattingData;
    }

    public static IPath getAutoTemplates(IPath workspaceTemplatePath) {
        File workspaceTemplateFile = workspaceTemplatePath.toFile();
        if (!workspaceTemplateFile.exists()) {
            try {
                IPath dafaultTemplatePath = VpeTemplateFileList.getFilePath(EMPTY_VPE_TEMPLATES_AUTO, null);
                File defaultTemplateFile = dafaultTemplatePath.toFile();
                VpeTemplateManager.copy(defaultTemplateFile, workspaceTemplateFile);
            }
            catch (IOException e) {
                VpePlugin.reportProblem(e);
            }
        }
        return workspaceTemplatePath;
    }

    public static IPath getAutoTemplates() {
        return VpeTemplateManager.getAutoTemplates(DEFAULT_AUTO_TEMPLATES_PATH);
    }

    private static void copy(File src, File dst) throws IOException {
        int len;
        dst.getParentFile().mkdirs();
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }
}

