/*
 * JBoss, Home of Professional Open Source.
 * See the COPYRIGHT.txt file distributed with this work for information
 * regarding copyright ownership.  Some portions may be licensed
 * to Red Hat, Inc. under one or more contributor license agreements.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 */
package org.komodo.rest.relational.json;

import static org.komodo.rest.Messages.Error.UNEXPECTED_JSON_TOKEN;
import java.io.IOException;
import org.komodo.rest.Messages;
import org.komodo.rest.relational.response.RestQueryColumn;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * A GSON serializer/deserializer for {@status RestQueryColumn}s.
 */
public class QueryColumnSerializer extends TypeAdapter<RestQueryColumn> {

    /**
     * {@inheritDoc}
     *
     * @see com.google.gson.TypeAdapter#read(com.google.gson.stream.JsonReader)
     */
    @Override
    public RestQueryColumn read( final JsonReader in ) throws IOException {
        final RestQueryColumn queryColumn = new RestQueryColumn();
        in.beginObject();

        while ( in.hasNext() ) {
            final String name = in.nextName();

            if (name.equals(RestQueryColumn.NAME_LABEL)) {
                queryColumn.setName(in.nextString());
            }
            else if (name.equals(RestQueryColumn.LABEL_LABEL)) {
                queryColumn.setLabel(in.nextString());
            }
            else if (name.equals(RestQueryColumn.TYPE_LABEL)) {
                queryColumn.setType(in.nextString());
            }
            else {
                throw new IOException( Messages.getString( UNEXPECTED_JSON_TOKEN, name ) );
            }
        }

        in.endObject();

        return queryColumn;
    }

    /**
     * {@inheritDoc}
     *
     * @see com.google.gson.TypeAdapter#write(com.google.gson.stream.JsonWriter, java.lang.Object)
     */
    @Override
    public void write( final JsonWriter out, final RestQueryColumn value ) throws IOException {

        out.beginObject();

        out.name(RestQueryColumn.NAME_LABEL);
        out.value(value.getName());

        out.name(RestQueryColumn.LABEL_LABEL);
        out.value(value.getLabel());

        out.name(RestQueryColumn.TYPE_LABEL);
        out.value(value.getType());

        out.endObject();
    }

}
