/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.util;

import javax.jcr.Repository;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.dna.common.SystemFailureException;
import org.jboss.dna.common.util.ArgCheck;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.util.AbstractSessionFactory;

public class JndiSessionFactory
extends AbstractSessionFactory {
    private final Context context;

    public JndiSessionFactory() throws NamingException {
        this(new InitialContext());
    }

    public JndiSessionFactory(char ... workspaceDelimiters) throws NamingException {
        this(new InitialContext(), workspaceDelimiters);
    }

    public JndiSessionFactory(Context context) {
        this(context, DEFAULT_DELIMITERS);
    }

    public JndiSessionFactory(Context context, char ... workspaceDelimiters) {
        super(workspaceDelimiters);
        ArgCheck.isNotNull((Object)context, (String)"initial context");
        this.context = context;
    }

    protected void doRegisterRepository(String name, Repository repository) throws SystemFailureException {
        try {
            this.context.bind(name, (Object)repository);
        }
        catch (NamingException e) {
            throw new SystemFailureException(RepositoryI18n.unableToRegisterRepositoryInJndi.text(new Object[]{name}));
        }
    }

    protected void doUnregisterRepository(String name) throws SystemFailureException {
        try {
            this.context.unbind(name);
        }
        catch (NamingException e) {
            throw new SystemFailureException(RepositoryI18n.unableToUnregisterRepositoryInJndi.text(new Object[]{name}));
        }
    }

    protected Repository findRegisteredRepository(String name) throws SystemFailureException {
        try {
            return (Repository)this.context.lookup(name);
        }
        catch (NamingException e) {
            throw new SystemFailureException(RepositoryI18n.unableToFindRepositoryInJndi.text(new Object[]{name}));
        }
    }
}

