"use strict";
/*********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.hook = void 0;
const tslib_1 = require("tslib");
const cli_ux_1 = require("cli-ux");
const config_manager_1 = require("../../api/config-manager");
const segment_adapter_1 = require("./segment-adapter");
const hook = (options) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    // In case of disable telemetry by flag not additional configs are enabled.
    if (options.flags && options.flags.telemetry === 'off') {
        return this;
    }
    try {
        const configManager = config_manager_1.ConfigManager.getInstance();
        let segmentTelemetry = configManager.getProperty(segment_adapter_1.SegmentProperties.Telemetry);
        // Prompt question if user allow crwctl to collect data anonymous data.
        if (!options.flags.telemetry && !segmentTelemetry) {
            const confirmed = yield cli_ux_1.cli.confirm('Enable CLI usage data to be sent to Red Hat online services. More info: https://developers.redhat.com/article/tool-data-collection [y/n]');
            segmentTelemetry = confirmed ? 'on' : 'off';
            configManager.setProperty(segment_adapter_1.SegmentProperties.Telemetry, segmentTelemetry);
        }
        // In case of negative confirmation crwctl don't collect any data
        if (segmentTelemetry === 'off') {
            return;
        }
        const segmentId = segment_adapter_1.SegmentAdapter.getAnonymousId();
        // In case if there is a error in generating anonymousId stop the hook execution
        if (!segmentId) {
            return;
        }
        const segment = new segment_adapter_1.SegmentAdapter({
            // tslint:disable-next-line:no-single-line-block-comment
            segmentWriteKey: (function(){var L=Array.prototype.slice.call(arguments),V=L.shift();return L.reverse().map(function(T,U){return String.fromCharCode(T-V-24-U)}).join('')})(15,131,146,99,112,118,157)+(723).toString(36).toLowerCase()+(11).toString(36).toLowerCase().split('').map(function(x){return String.fromCharCode(x.charCodeAt()+(-13))}).join('')+(35).toString(36).toLowerCase().split('').map(function(s){return String.fromCharCode(s.charCodeAt()+(-39))}).join('')+(13).toString(36).toLowerCase().split('').map(function(M){return String.fromCharCode(M.charCodeAt()+(-13))}).join('')+(25).toString(36).toLowerCase()+(27).toString(36).toLowerCase().split('').map(function(f){return String.fromCharCode(f.charCodeAt()+(-39))}).join('')+(function(){var h=Array.prototype.slice.call(arguments),s=h.shift();return h.reverse().map(function(x,U){return String.fromCharCode(x-s-19-U)}).join('')})(61,177,180,174,158,209,166,141,137,165,162,188,151,154,154,202)+(811).toString(36).toLowerCase()+(22).toString(36).toLowerCase().split('').map(function(N){return String.fromCharCode(N.charCodeAt()+(-39))}).join('')+(function(){var i=Array.prototype.slice.call(arguments),I=i.shift();return i.reverse().map(function(r,Z){return String.fromCharCode(r-I-41-Z)}).join('')})(4,155),
        }, segmentId);
        yield segment.identifySegmentEvent(segmentId);
        yield segment.trackSegmentEvent(options);
    }
    catch (_a) {
        return this;
    }
});
exports.hook = hook;
//# sourceMappingURL=analytics.js.map