"use strict";
/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@oclif/command");
const cli_ux_1 = require("cli-ux");
const che_api_client_1 = require("../../api/che-api-client");
const che_login_manager_1 = require("../../api/che-login-manager");
const context_1 = require("../../api/context");
const common_flags_1 = require("../../common-flags");
const constants_1 = require("../../constants");
class Stop extends command_1.Command {
    run() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { flags, args } = this.parse(Stop);
            yield context_1.ChectlContext.init(flags, this);
            yield this.config.runHook(constants_1.DEFAULT_ANALYTIC_HOOK_NAME, { command: Stop.id, flags });
            const workspaceId = args.workspace;
            const { cheApiEndpoint, accessToken } = yield che_login_manager_1.getLoginData(flags[common_flags_1.CHE_API_ENDPOINT_KEY], flags[common_flags_1.ACCESS_TOKEN_KEY], flags);
            const cheApiClient = che_api_client_1.CheApiClient.getInstance(cheApiEndpoint);
            yield cheApiClient.stopWorkspace(workspaceId, accessToken);
            cli_ux_1.cli.log(`Workspace ${workspaceId} successfully stopped.`);
            this.exit(0);
        });
    }
}
exports.default = Stop;
Stop.description = 'Stop a running workspace';
Stop.flags = {
    help: command_1.flags.help({ char: 'h' }),
    [common_flags_1.CHE_API_ENDPOINT_KEY]: common_flags_1.cheApiEndpoint,
    [common_flags_1.ACCESS_TOKEN_KEY]: common_flags_1.accessToken,
    chenamespace: common_flags_1.cheNamespace,
    'skip-kubernetes-health-check': common_flags_1.skipKubeHealthzCheck,
    telemetry: common_flags_1.CHE_TELEMETRY
};
Stop.args = [
    {
        name: 'workspace',
        description: 'The workspace id to stop',
        required: true
    }
];
//# sourceMappingURL=stop.js.map