/*********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
import Command from '@oclif/command';
/**
 * crwctl command context.
 * Can be requested from any location with `ChectlContext#get`
 */
export declare namespace ChectlContext {
    const IS_OPENSHIFT = "isOpenShift";
    const IS_OPENSHIFT4 = "isOpenShift4";
    const START_TIME = "startTime";
    const END_TIME = "endTime";
    const CONFIG_DIR = "configDir";
    const CACHE_DIR = "cacheDir";
    const ERROR_LOG = "errorLog";
    const COMMAND_ID = "commandId";
    const CUSTOM_CR = "customCR";
    const CR_PATCH = "crPatch";
    const LOGS_DIR = "directory";
    function init(flags: any, command: Command): Promise<void>;
    function initAndGet(flags: any, command: Command): Promise<any>;
    function get(): any;
}
