"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const _ = require("lodash");
exports.default = (env, opts = {}) => {
    const envs = [];
    return {
        run() {
            // normalize to undefined
            const normalizedEnv = _.mapValues(env, v => v === null ? undefined : v);
            // store previous env for finally
            envs.push(process.env);
            if (opts.clear) {
                process.env = Object.assign({}, normalizedEnv);
            }
            else {
                process.env = Object.assign(Object.assign({}, process.env), normalizedEnv);
                Object.entries(normalizedEnv)
                    .filter(([, v]) => v === undefined)
                    .forEach(([k]) => {
                    delete process.env[k];
                });
            }
        },
        finally() {
            const env = envs.pop();
            if (env)
                process.env = env;
        },
    };
};
