"use strict";
/*********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEFAULT_K8S_POD_ERROR_RECHECK_TIMEOUT = exports.DEFAULT_K8S_POD_WAIT_TIMEOUT = exports.DEFAULT_ANALYTIC_HOOK_NAME = exports.DEFAULT_DEV_WORKSPACE_CHE_NAMESPACE = exports.DEFAULT_DEV_WORKSPACE_CONTROLLER_NAMESPACE = exports.OUTPUT_SEPARATOR = exports.DOC_LINK_OBTAIN_ACCESS_TOKEN_OAUTH = exports.DOC_LINK_OBTAIN_ACCESS_TOKEN = exports.DOCS_LINK_HOW_TO_CREATE_USER_OS3 = exports.DOCS_LINK_HOW_TO_ADD_IDENTITY_PROVIDER_OS4 = exports.DOCS_LINK_IMPORT_CA_CERT_INTO_BROWSER = exports.DOCS_LINK_INSTALL_RUNNING_CHE_LOCALLY = exports.DOC_LINK_RELEASE_NOTES = exports.DOC_LINK = exports.DEFAULT_OLM_SUGGESTED_NAMESPACE = exports.NIGHTLY_CATALOG_SOURCE_NAME = exports.CVS_PREFIX = exports.OPENSHIFT_OLM_CATALOG = exports.KUBERNETES_OLM_CATALOG = exports.OPERATOR_GROUP_NAME = exports.SUBSCRIPTION_NAME = exports.CUSTOM_CATALOG_SOURCE_NAME = exports.DEFAULT_OLM_KUBERNETES_NAMESPACE = exports.DEFAULT_OPENSHIFT_MARKET_PLACE_NAMESPACE = exports.OLM_NIGHTLY_CHANNEL_NAME = exports.OLM_STABLE_CHANNEL_NAME = exports.DEFAULT_CHE_OLM_PACKAGE_NAME = exports.LEGACY_CHE_NAMESPACE = exports.DEFAULT_CHE_NAMESPACE = exports.CHE_OPERATOR_SELECTOR = exports.OPERATOR_DEPLOYMENT_NAME = exports.CHE_CLUSTER_CRD = exports.CHE_CLUSTER_CR_NAME = exports.DEFAULT_CA_CERT_FILE_NAME = exports.CHE_ROOT_CA_SECRET_NAME = exports.CHE_TLS_SECRET_NAME = exports.CERT_MANAGER_NAMESPACE_NAME = exports.CA_CERT_GENERATION_JOB_IMAGE = exports.DEFAULT_CHE_OPERATOR_IMAGE_NAME = exports.CHE_RELATED_COMPONENT_LABEL = exports.MIN_HELM_INSTALLER_VERSION = exports.MIN_CHE_OPERATOR_INSTALLER_VERSION = exports.MIN_OLM_INSTALLER_VERSION = exports.OPERATOR_TEMPLATE_DIR = exports.CHECTL_PROJECT_NAME = void 0;
exports.CHECTL_PROJECT_NAME = 'chectl';
exports.OPERATOR_TEMPLATE_DIR = 'codeready-workspaces-operator';
// minimal installable versions by current crwctl
exports.MIN_OLM_INSTALLER_VERSION = '7.17.0';
exports.MIN_CHE_OPERATOR_INSTALLER_VERSION = '7.13.1';
exports.MIN_HELM_INSTALLER_VERSION = '7.10.0';
// labels
exports.CHE_RELATED_COMPONENT_LABEL = 'client/org.eclipse.che=true';
// images
exports.DEFAULT_CHE_OPERATOR_IMAGE_NAME = 'registry.redhat.io/codeready-workspaces/crw-2-rhel8-operator';
// This image should be updated manually when needed.
// Repository location: https://github.com/che-dockerfiles/che-cert-manager-ca-cert-generator-image
exports.CA_CERT_GENERATION_JOB_IMAGE = 'quay.io/eclipse/che-cert-manager-ca-cert-generator:671342c';
exports.CERT_MANAGER_NAMESPACE_NAME = 'cert-manager';
exports.CHE_TLS_SECRET_NAME = 'che-tls';
exports.CHE_ROOT_CA_SECRET_NAME = 'self-signed-certificate';
exports.DEFAULT_CA_CERT_FILE_NAME = 'cheCA.crt';
exports.CHE_CLUSTER_CR_NAME = 'codeready-workspaces';
exports.CHE_CLUSTER_CRD = 'checlusters.org.eclipse.che';
// operator
exports.OPERATOR_DEPLOYMENT_NAME = 'codeready-operator';
exports.CHE_OPERATOR_SELECTOR = 'app=codeready-operator';
exports.DEFAULT_CHE_NAMESPACE = 'openshift-workspaces';
exports.LEGACY_CHE_NAMESPACE = 'workspaces';
// OLM
exports.DEFAULT_CHE_OLM_PACKAGE_NAME = 'codeready-workspaces';
exports.OLM_STABLE_CHANNEL_NAME = 'latest';
exports.OLM_NIGHTLY_CHANNEL_NAME = 'nightly';
exports.DEFAULT_OPENSHIFT_MARKET_PLACE_NAMESPACE = 'openshift-marketplace';
exports.DEFAULT_OLM_KUBERNETES_NAMESPACE = 'olm';
exports.CUSTOM_CATALOG_SOURCE_NAME = 'codeready-custom-catalog-source';
exports.SUBSCRIPTION_NAME = 'codeready-subscription';
exports.OPERATOR_GROUP_NAME = 'codeready-operator-group';
exports.KUBERNETES_OLM_CATALOG = 'operatorhubio-catalog';
exports.OPENSHIFT_OLM_CATALOG = 'redhat-operators';
exports.CVS_PREFIX = 'crwoperator';
exports.NIGHTLY_CATALOG_SOURCE_NAME = 'eclipse-che-preview';
exports.DEFAULT_OLM_SUGGESTED_NAMESPACE = 'openshift-workspaces';
// Documentation links
exports.DOC_LINK = 'https://access.redhat.com/documentation/en-us/red_hat_codeready_workspaces/2.9/';
exports.DOC_LINK_RELEASE_NOTES = 'https://access.redhat.com/documentation/en-us/red_hat_codeready_workspaces/2.9/html/release_notes_and_known_issues/index';
exports.DOCS_LINK_INSTALL_RUNNING_CHE_LOCALLY = 'https://www.eclipse.org/che/docs/che-7/installation-guide/installing-che-locally/';
exports.DOCS_LINK_IMPORT_CA_CERT_INTO_BROWSER = 'https://www.eclipse.org/che/docs/che-7/end-user-guide/importing-certificates-to-browsers/';
exports.DOCS_LINK_HOW_TO_ADD_IDENTITY_PROVIDER_OS4 = 'https://docs.openshift.com/container-platform/latest/authentication/understanding-identity-provider.html#identity-provider-overview_understanding-identity-provider';
exports.DOCS_LINK_HOW_TO_CREATE_USER_OS3 = 'https://docs.openshift.com/container-platform/3.11/install_config/configuring_authentication.html';
exports.DOC_LINK_OBTAIN_ACCESS_TOKEN = 'https://www.eclipse.org/che/docs/che-7/administration-guide/authenticating-users/#obtaining-the-token-from-keycloak_authenticating-to-the-che-server';
exports.DOC_LINK_OBTAIN_ACCESS_TOKEN_OAUTH = 'https://www.eclipse.org/che/docs/che-7/administration-guide/authenticating-users/#obtaining-the-token-from-openshift-token-through-keycloak_authenticating-to-the-che-server';
exports.OUTPUT_SEPARATOR = '-------------------------------------------------------------------------------';
// DevWorkspace
exports.DEFAULT_DEV_WORKSPACE_CONTROLLER_NAMESPACE = 'devworkspace-controller';
// DevWorkspace Che
exports.DEFAULT_DEV_WORKSPACE_CHE_NAMESPACE = 'devworkspace-che';
// HOOKS
exports.DEFAULT_ANALYTIC_HOOK_NAME = 'analytics';
// Timeouts
exports.DEFAULT_K8S_POD_WAIT_TIMEOUT = 600000;
exports.DEFAULT_K8S_POD_ERROR_RECHECK_TIMEOUT = 15000;
//# sourceMappingURL=constants.js.map