"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function nock(host, options, cb) {
    if (typeof options === 'function') {
        cb = options;
        options = {};
    }
    if (cb === undefined)
        throw new Error('callback is undefined');
    let nock;
    try {
        nock = require('nock');
    }
    catch (_a) {
        return {
            run() {
                require('nock');
            },
        };
    }
    const intercepter = nock(host, options);
    return {
        async run(ctx) {
            ctx.nock = ctx.nock || 0;
            await cb(intercepter);
            ctx.nock++;
        },
        finally(ctx) {
            if (!ctx.error)
                intercepter.done();
            ctx.nock--;
            if (ctx.nock === 0)
                nock.cleanAll();
        },
    };
}
exports.nock = nock;
