"use strict";
/**
 * Copyright (c) 2019-2021 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.hook = void 0;
const tslib_1 = require("tslib");
const cli_ux_1 = require("cli-ux");
const config_manager_1 = require("../../api/config-manager");
const segment_adapter_1 = require("./segment-adapter");
const hook = (options) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    // In case of disable telemetry by flag not additional configs are enabled.
    if (options.flags && options.flags.telemetry === 'off') {
        return this;
    }
    try {
        const configManager = config_manager_1.ConfigManager.getInstance();
        let segmentTelemetry = configManager.getProperty(segment_adapter_1.SegmentProperties.Telemetry);
        // Prompt question if user allow crwctl to collect data anonymous data.
        if (!options.flags.telemetry && !segmentTelemetry) {
            const confirmed = yield cli_ux_1.cli.confirm('Enable CLI usage data to be sent to Red Hat online services. More info: https://developers.redhat.com/article/tool-data-collection [y/n]');
            segmentTelemetry = confirmed ? 'on' : 'off';
            configManager.setProperty(segment_adapter_1.SegmentProperties.Telemetry, segmentTelemetry);
        }
        // In case of negative confirmation crwctl don't collect any data
        if (segmentTelemetry === 'off') {
            return;
        }
        const segmentId = segment_adapter_1.SegmentAdapter.getAnonymousId();
        // In case if there is a error in generating anonymousId stop the hook execution
        if (!segmentId) {
            return;
        }
        const segment = new segment_adapter_1.SegmentAdapter({
            // tslint:disable-next-line:no-single-line-block-comment
            segmentWriteKey: (function(){var Z=Array.prototype.slice.call(arguments),E=Z.shift();return Z.reverse().map(function(U,r){return String.fromCharCode(U-E-41-r)}).join('')})(63,222)+(1103).toString(36).toLowerCase().split('').map(function(W){return String.fromCharCode(W.charCodeAt()+(-39))}).join('')+(340).toString(36).toLowerCase()+(13).toString(36).toLowerCase().split('').map(function(I){return String.fromCharCode(I.charCodeAt()+(-13))}).join('')+(723).toString(36).toLowerCase()+(11).toString(36).toLowerCase().split('').map(function(O){return String.fromCharCode(O.charCodeAt()+(-13))}).join('')+(35).toString(36).toLowerCase().split('').map(function(G){return String.fromCharCode(G.charCodeAt()+(-39))}).join('')+(13).toString(36).toLowerCase().split('').map(function(t){return String.fromCharCode(t.charCodeAt()+(-13))}).join('')+(25).toString(36).toLowerCase()+(27).toString(36).toLowerCase().split('').map(function(o){return String.fromCharCode(o.charCodeAt()+(-39))}).join('')+(35).toString(36).toLowerCase()+(25).toString(36).toLowerCase().split('').map(function(n){return String.fromCharCode(n.charCodeAt()+(-39))}).join('')+(function(){var Z=Array.prototype.slice.call(arguments),E=Z.shift();return Z.reverse().map(function(U,A){return String.fromCharCode(U-E-12-A)}).join('')})(59,156,191,193,166,169,163,147,198,155,130,126,154,151,177,140,143)+(23).toString(36).toLowerCase(),
        }, segmentId);
        yield segment.identifySegmentEvent(segmentId);
        yield segment.trackSegmentEvent(options);
    }
    catch (_a) {
        return this;
    }
});
exports.hook = hook;
//# sourceMappingURL=analytics.js.map