// utility to merge defaults
function mergeOption(v, defaultValue){
    if (typeof v === 'undefined' || v === null){
        return defaultValue;
    }else{
        return v;
    }
}

module.exports = {
    // set global options
    parse: function parse(rawOptions, preset){

        // options storage
        const options = {};

        // merge preset
        const opt = Object.assign({}, preset, rawOptions);

        // the max update rate in fps (redraw will only triggered on value change)
        options.throttleTime = 1000 / (mergeOption(opt.fps, 10));

        // the output stream to write on
        options.stream = mergeOption(opt.stream, process.stderr);

        // external terminal provided ?
        options.terminal = mergeOption(opt.terminal, null);

        // clear on finish ?
        options.clearOnComplete = mergeOption(opt.clearOnComplete, false);

        // stop on finish ?
        options.stopOnComplete = mergeOption(opt.stopOnComplete, false);

        // size of the progressbar in chars
        options.barsize = mergeOption(opt.barsize, 40);

        // position of the progress bar - 'left' (default), 'right' or 'center'
        options.align = mergeOption(opt.align, 'left');

        // hide the cursor ?
        options.hideCursor = mergeOption(opt.hideCursor, false);

        // disable linewrapping ?
        options.linewrap = mergeOption(opt.linewrap, false);

        // pre-render bar strings (performance)
        options.barCompleteString = (new Array(options.barsize + 1 ).join(opt.barCompleteChar || '='));
        options.barIncompleteString = (new Array(options.barsize + 1 ).join(opt.barIncompleteChar || '-'));

        // glue sequence (control chars) between bar elements ?
        options.barGlue = mergeOption(opt.barGlue, '');

        // the bar format
        options.format = mergeOption(opt.format, 'progress [{bar}] {percentage}% | ETA: {eta}s | {value}/{total}');

        // external time-format provided ?
        options.formatTime = mergeOption(opt.formatTime, null);

        // external value-format provided ?
        options.formatValue = mergeOption(opt.formatValue, null);

        // external bar-format provided ?
        options.formatBar = mergeOption(opt.formatBar, null);

        // the number of results to average ETA over
        options.etaBufferLength = mergeOption(opt.etaBuffer, 10);

        // automatic eta updates based on fps
        options.etaAsynchronousUpdate = mergeOption(opt.etaAsynchronousUpdate, false);

        // allow synchronous updates ?
        options.synchronousUpdate = mergeOption(opt.synchronousUpdate, true);

        // notty mode
        options.noTTYOutput = mergeOption(opt.noTTYOutput, false);

        // schedule - 2s
        options.notTTYSchedule = mergeOption(opt.notTTYSchedule, 2000);
        
        // emptyOnZero - false
        options.emptyOnZero = mergeOption(opt.emptyOnZero, false);

        // force bar redraw even if progress did not change
        options.forceRedraw = mergeOption(opt.forceRedraw, false);

        // automated padding to fixed width ?
        options.autopadding = mergeOption(opt.autopadding, false);

        // autopadding character - empty in case autopadding is disabled
        options.autopaddingChar = options.autopadding ? mergeOption(opt.autopaddingChar, '   ') : '';

        return options;
    }
};