/**
 * Copyright (c) 2019-2021 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
import { V1Deployment } from '@kubernetes/client-node';
import { Command } from '@oclif/command';
import * as Listr from 'listr';
export declare class OperatorTasks {
    operatorServiceAccount: string;
    legacyClusterResourcesName: string;
    devworkspaceCheNamePrefix: string;
    private getReadRolesAndBindingsTask;
    private getCreateOrUpdateRolesAndBindingsTask;
    /**
     * Returns tasks list which perform preflight platform checks.
     */
    deployTasks(flags: any, command: Command): Promise<Listr>;
    preUpdateTasks(flags: any, command: Command): Listr;
    updateTasks(flags: any, command: Command): Listr;
    /**
     * Returns list of tasks which remove CodeReady Workspaces operator related resources
     */
    deleteTasks(flags: any): ReadonlyArray<Listr.ListrTask>;
    retrieveContainerImage(deployment: V1Deployment): string;
    getCRDPath(ctx: any, flags: any): Promise<string>;
    private getBackupRestoreCrdFilesNames;
    /**
     * Reads and patch 'codeready-operator' deployment:
     * - sets operator image
     * - sets deployment namespace
     * - removes other containers for ocp 3.11
     */
    private readOperatorDeployment;
}
