/**
 * Copyright (c) 2019-2021 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
import Command from '@oclif/command';
import * as Listr from 'listr';
import { KubeHelper } from '../../api/kube';
export declare function createNamespaceTask(namespaceName: string, labels: {}): Listr.ListrTask;
export declare function checkChectlAndCheVersionCompatibility(flags: any): Listr.ListrTask;
/**
 * Sets flags.templates based on required version and installer.
 * Does not support OLM.
 */
export declare function downloadTemplates(flags: any): Listr.ListrTask;
export declare function createEclipseCheCluster(flags: any, kube: KubeHelper): Listr.ListrTask;
/**
 * Update CheCluster CR object using CR patch file.
 * Clean up custom images if they weren't defined in the CR patch file to prevent update failing.
 * @param flags - parent command flags
 * @param kube - kubeHelper util
 * @param command - parent command
 */
export declare function patchingEclipseCheCluster(flags: any, kube: KubeHelper, command: Command): Listr.ListrTask;
export declare function retrieveCheCaCertificateTask(flags: any): Listr.ListrTask;
export declare function getMessageImportCaCertIntoBrowser(caCertFileLocation: string): string;
/**
 * Prints important to user messages which are stored in ctx.highlightedMessages
 * Typically this task is the last task of a command.
 */
export declare function getPrintHighlightedMessagesTask(): Listr.ListrTask;
