/*
 * JBoss, the OpenSource EJB server
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package javax.resource.spi.security;

import javax.resource.spi.SecurityException;

/**
 * The interface GenericCredential defines a method of representing a security
 * credential for a resource which is independent of the security mechanism. It
 * can be used to wrap any type of underlying credentials, for example it could
 * be used to wrap Kerberos credentials. This allows the resource adapter to
 * utilize the credentials for sign-on to the EIS.
 * 
 * @deprecated Use org.ietf.jgss.GSSCredential
 */
public interface GenericCredential
{
   /**
	 * Gets security data from the credential.
	 * 
	 * @deprecated Use org.ietf.jgss.GSSCredential
	 * @return Credential data
	 */
   public byte[] getCredentialData() throws SecurityException;

   /**
	 * Returns the mechanism type for the credential
	 * 
	 * @deprecated Use org.ietf.jgss.GSSCredential
	 * @return Mechanism Type
	 */
   public String getMechType();

   /**
	 * Returns the name of the principal associated with the credential
	 * 
	 * @deprecated Use org.ietf.jgss.GSSCredential
	 * @return Principal name
	 */
   public String getName();

   /**
	 * Tests object for equality
	 * 
	 * @deprecated Use org.ietf.jgss.GSSCredential
	 */
   public boolean equals(Object other);

   /**
	 * Generates a hashCode for this object
	 * 
	 * @deprecated Use org.ietf.jgss.GSSCredential
	 */
   public int hashCode();
}