package com.izforge.izpack.gui.patternfly;

import com.izforge.izpack.panels.JFocusPanel;

import javax.swing.*;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import java.awt.*;

/**
 * Created by daniel on 12/15/16.
 */

public class PatternflyTextFieldUI extends BasicTextFieldUI{

    public PatternflyTextFieldUI(){
        super();
    }

    public void update(final Graphics g, JComponent c){
        super.update(g,c);
        if(!(c.getParent() instanceof JFocusPanel)) return;
        JFocusPanel p = (JFocusPanel) c.getParent();

        if(c.hasFocus()) {
            p.setFocusBorder(true);
        }else{
            p.setFocusBorder(false);
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new PatternflyTextFieldUI();
    }
}
