package com.izforge.izpack.gui.patternfly;

import com.izforge.izpack.gui.UiResources;

import javax.swing.*;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.plaf.metal.MetalTreeUI;
import java.awt.*;

/**
 * Created by dsoukhov on 15/11/16.
 */
public class PatternflyJTreeUI extends MetalTreeUI{

    public PatternflyJTreeUI(){
        super();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
        JTree jt = (JTree) c;
        if (jt.hasFocus()) {
            paintFocusBorder(g, jt.getVisibleRect(), jt.getRowCount(), (int)jt.getRowBounds(0).getHeight());
        }
    }

    private void paintFocusBorder(Graphics g, Rectangle treeBounds, int numRows, int rowHeight) {
        Graphics2D g2d = (Graphics2D) g;
        g2d.setColor(UiResources.blueFocus);
        g2d.setStroke(new BasicStroke());
        g2d.draw(new Rectangle(treeBounds.x,treeBounds.y,treeBounds.width-1, rowHeight*numRows));
    }

    public static ComponentUI createUI(JComponent c) {
        return new PatternflyJTreeUI();
    }
}
