/*
 * Copyright 2018-2019, EnMasse authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "github.com/enmasseproject/enmasse/pkg/apis/enmasse/v1beta1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// AddressSpaceLister helps list AddressSpaces.
type AddressSpaceLister interface {
	// List lists all AddressSpaces in the indexer.
	List(selector labels.Selector) (ret []*v1beta1.AddressSpace, err error)
	// AddressSpaces returns an object that can list and get AddressSpaces.
	AddressSpaces(namespace string) AddressSpaceNamespaceLister
	AddressSpaceListerExpansion
}

// addressSpaceLister implements the AddressSpaceLister interface.
type addressSpaceLister struct {
	indexer cache.Indexer
}

// NewAddressSpaceLister returns a new AddressSpaceLister.
func NewAddressSpaceLister(indexer cache.Indexer) AddressSpaceLister {
	return &addressSpaceLister{indexer: indexer}
}

// List lists all AddressSpaces in the indexer.
func (s *addressSpaceLister) List(selector labels.Selector) (ret []*v1beta1.AddressSpace, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.AddressSpace))
	})
	return ret, err
}

// AddressSpaces returns an object that can list and get AddressSpaces.
func (s *addressSpaceLister) AddressSpaces(namespace string) AddressSpaceNamespaceLister {
	return addressSpaceNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// AddressSpaceNamespaceLister helps list and get AddressSpaces.
type AddressSpaceNamespaceLister interface {
	// List lists all AddressSpaces in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1beta1.AddressSpace, err error)
	// Get retrieves the AddressSpace from the indexer for a given namespace and name.
	Get(name string) (*v1beta1.AddressSpace, error)
	AddressSpaceNamespaceListerExpansion
}

// addressSpaceNamespaceLister implements the AddressSpaceNamespaceLister
// interface.
type addressSpaceNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all AddressSpaces in the indexer for a given namespace.
func (s addressSpaceNamespaceLister) List(selector labels.Selector) (ret []*v1beta1.AddressSpace, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.AddressSpace))
	})
	return ret, err
}

// Get retrieves the AddressSpace from the indexer for a given namespace and name.
func (s addressSpaceNamespaceLister) Get(name string) (*v1beta1.AddressSpace, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1beta1.Resource("addressspace"), name)
	}
	return obj.(*v1beta1.AddressSpace), nil
}
