/*
 * Copyright 2018-2019, EnMasse authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1alpha1 "github.com/enmasseproject/enmasse/pkg/apis/iot/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeIoTConfigs implements IoTConfigInterface
type FakeIoTConfigs struct {
	Fake *FakeIotV1alpha1
	ns   string
}

var iotconfigsResource = schema.GroupVersionResource{Group: "iot.enmasse.io", Version: "v1alpha1", Resource: "iotconfigs"}

var iotconfigsKind = schema.GroupVersionKind{Group: "iot.enmasse.io", Version: "v1alpha1", Kind: "IoTConfig"}

// Get takes name of the ioTConfig, and returns the corresponding ioTConfig object, and an error if there is any.
func (c *FakeIoTConfigs) Get(name string, options v1.GetOptions) (result *v1alpha1.IoTConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(iotconfigsResource, c.ns, name), &v1alpha1.IoTConfig{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.IoTConfig), err
}

// List takes label and field selectors, and returns the list of IoTConfigs that match those selectors.
func (c *FakeIoTConfigs) List(opts v1.ListOptions) (result *v1alpha1.IoTConfigList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(iotconfigsResource, iotconfigsKind, c.ns, opts), &v1alpha1.IoTConfigList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.IoTConfigList{ListMeta: obj.(*v1alpha1.IoTConfigList).ListMeta}
	for _, item := range obj.(*v1alpha1.IoTConfigList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested ioTConfigs.
func (c *FakeIoTConfigs) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(iotconfigsResource, c.ns, opts))

}

// Create takes the representation of a ioTConfig and creates it.  Returns the server's representation of the ioTConfig, and an error, if there is any.
func (c *FakeIoTConfigs) Create(ioTConfig *v1alpha1.IoTConfig) (result *v1alpha1.IoTConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(iotconfigsResource, c.ns, ioTConfig), &v1alpha1.IoTConfig{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.IoTConfig), err
}

// Update takes the representation of a ioTConfig and updates it. Returns the server's representation of the ioTConfig, and an error, if there is any.
func (c *FakeIoTConfigs) Update(ioTConfig *v1alpha1.IoTConfig) (result *v1alpha1.IoTConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(iotconfigsResource, c.ns, ioTConfig), &v1alpha1.IoTConfig{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.IoTConfig), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeIoTConfigs) UpdateStatus(ioTConfig *v1alpha1.IoTConfig) (*v1alpha1.IoTConfig, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(iotconfigsResource, "status", c.ns, ioTConfig), &v1alpha1.IoTConfig{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.IoTConfig), err
}

// Delete takes name of the ioTConfig and deletes it. Returns an error if one occurs.
func (c *FakeIoTConfigs) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(iotconfigsResource, c.ns, name), &v1alpha1.IoTConfig{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeIoTConfigs) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(iotconfigsResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1alpha1.IoTConfigList{})
	return err
}

// Patch applies the patch and returns the patched ioTConfig.
func (c *FakeIoTConfigs) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.IoTConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(iotconfigsResource, c.ns, name, data, subresources...), &v1alpha1.IoTConfig{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.IoTConfig), err
}
