/*
 * Copyright 2018, Strimzi authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */
package io.strimzi.operator.common.operator.resource;

import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.vertx.core.Future;
import io.vertx.core.Vertx;

/**
 * This class is a temporary work-around for the fact that Fabric8 doesn't
 * yet support an API for manipulating Kubernetes ClusterRoleBindings
 * @deprecated This can be removed once support for ClusterRoles and ClusterRoleBindings is in Fabric8.
 */
@Deprecated
public class ClusterRoleBindingOperator extends WorkaroundRbacOperator<ClusterRoleBindingOperator.ClusterRoleBinding> {

    public ClusterRoleBindingOperator(Vertx vertx, KubernetesClient client) {
        super(vertx, client, "rbac.authorization.k8s.io", "v1beta1", "clusterrolebindings");
    }

    public static class ClusterRoleBinding {
        private final String serviceAccountName;
        private final String serviceAccountNamespace;
        private final String name;
        private final String clusterRoleName;
        private final OwnerReference ownerRef;

        public ClusterRoleBinding(
                String name,
                String clusterRoleName,
                String serviceAccountNamespace,
                String serviceAccountName,
                OwnerReference ownerRef) {
            this.name = name;
            this.clusterRoleName = clusterRoleName;
            this.serviceAccountNamespace = serviceAccountNamespace;
            this.serviceAccountName = serviceAccountName;
            this.ownerRef = ownerRef;
        }
        public String toString() {
            return "{\"apiVersion\": \"rbac.authorization.k8s.io/v1beta1\"," +
                   "\"kind\": \"ClusterRoleBinding\"," +
                   "\"metadata\":{" +
                   "  \"name\": \"" + name + "\"," +
                   "  \"labels\":{" +
                   "    \"app\": \"strimzi\"" +
                    "}," +
                    "        \"ownerReferences\": [" +
                    "            {" +
                    "                \"apiVersion\": \"" + ownerRef.getApiVersion() + "\"," +
                    "                \"blockOwnerDeletion\": " + ownerRef.getBlockOwnerDeletion() + "," +
                    "                \"controller\": " + ownerRef.getController() + "," +
                    "                \"kind\": \"" + ownerRef.getKind() + "\"," +
                    "                \"name\": \"" + ownerRef.getName() + "\"," +
                    "                \"uid\": \"" + ownerRef.getUid() + "\"" +
                    "            }" +
                    "        ]" +
                    "}," +
                   "\"subjects\":[" +
                   "  { \"kind\": \"ServiceAccount\"," +
                   "    \"name\": \"" + serviceAccountName + "\"," +
                   "    \"namespace\": \"" + serviceAccountNamespace + "\"" +
                    "}" +
                    "]," +
                   "\"roleRef\":{" +
                   "  \"kind\": \"ClusterRole\"," +
                   "  \"name\": \"" + clusterRoleName + "\"," +
                   "  \"apiGroup\": \"rbac.authorization.k8s.io\"}" +
                    "}";
        }
    }

    private String urlWithoutName() {
        return baseUrl + "apis/" + group + "/" + apiVersion + "/" + plural;
    }

    private String urlWithName(String name) {
        return urlWithoutName() + "/" + name;
    }

    public Future<Void> reconcile(String name, ClusterRoleBinding resource) {
        return doReconcile(urlWithoutName(), urlWithName(name), resource);
    }

}
