/**
 * Copyright (C) FuseSource, Inc.
 * http://fusesource.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.fabric8.itests.smoke;

import java.util.LinkedList;
import java.util.List;

import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ServiceProxy;
import io.fabric8.itests.paxexam.support.FabricTestSupport;

import org.apache.karaf.tooling.exam.options.KarafDistributionOption;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;

@RunWith(JUnit4TestRunner.class)
@ExamReactorStrategy(AllConfinedStagedReactorFactory.class)
public class FabricCreateTest extends FabricTestSupport {

    @Test
    public void testCreateWithProfileSelection() throws Exception {
        System.err.println(executeCommand("fabric:create --clean -n --profile feature-camel"));
        ServiceProxy<FabricService> fabricProxy = ServiceProxy.createServiceProxy(bundleContext, FabricService.class);
        try {
            FabricService fabricService = fabricProxy.getService();
            Profile karafProfile = fabricService.getDefaultVersion().getProfile("karaf");
            Assert.assertNotNull(karafProfile);

            Profile camelProfile = fabricService.getDefaultVersion().getProfile("feature-camel");
            Assert.assertNotNull(camelProfile);

            Profile activeMq = fabricService.getDefaultVersion().getProfile("mq-default");
            Assert.assertNotNull(activeMq);


            Profile[] profiles = fabricService.getCurrentContainer().getProfiles();
            List<String> profileNames = new LinkedList<String>();
            for (Profile profile : profiles) {
                profileNames.add(profile.getId());
            }

            Assert.assertTrue(profileNames.contains("fabric"));
            Assert.assertTrue(profileNames.contains("feature-camel"));
        } finally {
            fabricProxy.close();
        }
    }

    @Configuration
    public Option[] config() {
        return new Option[]{
                new DefaultCompositeOption(fabricDistributionConfiguration()),
                KarafDistributionOption.debugConfiguration("5005", false)
        };
    }
}
