/*
 *   Licensed to the Apache Software Foundation (ASF) under one
 *   or more contributor license agreements.  See the NOTICE file
 *   distributed with this work for additional information
 *   regarding copyright ownership.  The ASF licenses this file
 *   to you under the Apache License, Version 2.0 (the
 *   "License"); you may not use this file except in compliance
 *   with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing,
 *   software distributed under the License is distributed on an
 *   "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *   KIND, either express or implied.  See the License for the
 *   specific language governing permissions and limitations
 *   under the License.
 *
 */
package org.apache.directory.shared.ldap.constants;


/**
 * Apache meta schema specific constants used throughout the server.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 * @version $Rev$, $Date$
 */
public interface MetaSchemaConstants
{
    String SCHEMA_NAME = "apachemeta";
    String SCHEMA_OTHER = "other";

    // -- objectClass names --
    
    String META_TOP_OC                      = "metaTop";
    String META_TOP_OC_OID                  = "1.3.6.1.4.1.18060.0.4.0.3.1";
    
    String META_OBJECT_CLASS_OC             = "metaObjectClass";
    String META_OBJECT_CLASS_OC_OID         = "1.3.6.1.4.1.18060.0.4.0.3.2";
    
    String META_ATTRIBUTE_TYPE_OC           = "metaAttributeType";
    String META_ATTRIBUTE_TYPE_OC_OID       = "1.3.6.1.4.1.18060.0.4.0.3.3";
    
    String META_SYNTAX_OC                   = "metaSyntax";
    String META_SYNTAX_OC_OID               = "1.3.6.1.4.1.18060.0.4.0.3.4";

    String META_MATCHING_RULE_OC            = "metaMatchingRule";
    String META_MATCHING_RULE_OC_OID        = "1.3.6.1.4.1.18060.0.4.0.3.5";
    
    String META_DIT_STRUCTURE_RULE_OC       = "metaDITStructureRule";
    String META_DIT_STRUCTURE_RULE_OC_OID   = "1.3.6.1.4.1.18060.0.4.0.3.6";
    
    String META_NAME_FORM_OC                = "metaNameForm";
    String META_NAME_FORM_OC_OID            = "1.3.6.1.4.1.18060.0.4.0.3.7";

    String META_MATCHING_RULE_USE_OC        = "metaMatchingRuleUse";
    String META_MATCHING_RULE_USE_OC_OID    = "1.3.6.1.4.1.18060.0.4.0.3.8";

    String META_DIT_CONTENT_RULE_OC         = "metaDITContentRule";
    String META_DIT_CONTENT_RULE_OC_OID     = "1.3.6.1.4.1.18060.0.4.0.3.9";
    
    String META_SYNTAX_CHECKER_OC           = "metaSyntaxChecker";
    String META_SYNTAX_CHECKER_OC_OID       = "1.3.6.1.4.1.18060.0.4.0.3.10";
    
    String META_SCHEMA_OC                   = "metaSchema";
    String META_SCHEMA_OC_OID               = "1.3.6.1.4.1.18060.0.4.0.3.11";
    
    String META_NORMALIZER_OC               = "metaNormalizer";
    String META_NORMALIZER_OC_OID           = "1.3.6.1.4.1.18060.0.4.0.3.12";
    
    String META_COMPARATOR_OC               = "metaComparator";
    String META_COMPARATOR_OC_OID           = "1.3.6.1.4.1.18060.0.4.0.3.13";


    // -- attributeType names --
    String M_OID_AT                         = "m-oid";
    String M_OID_AT_OID                     = "1.3.6.1.4.1.18060.0.4.0.2.1 ";

    String M_NAME_AT                        = "m-name";
    String M_NAME_AT_OID                    = "1.3.6.1.4.1.18060.0.4.0.2.2 ";

    String M_DESCRIPTION_AT                 = "m-description";
    String M_DESCRIPTION_AT_OID             = "1.3.6.1.4.1.18060.0.4.0.2.3 ";
    
    String M_OBSOLETE_AT                    = "m-obsolete";
    String M_OBSOLETE_AT_OID                = "1.3.6.1.4.1.18060.0.4.0.2.4 ";
    
    String M_SUP_OBJECT_CLASS_AT            = "m-supObjectClass";
    String M_SUP_OBJECT_CLASS_AT_OID        = "1.3.6.1.4.1.18060.0.4.0.2.5 ";
    
    String M_MUST_AT                        = "m-must";
    String M_MUST_AT_OID                    = "1.3.6.1.4.1.18060.0.4.0.2.6 ";

    String M_MAY_AT                         = "m-may";
    String M_MAY_AT_OID                     = "1.3.6.1.4.1.18060.0.4.0.2.7 ";

    String M_TYPE_OBJECT_CLASS_AT           = "m-typeObjectClass";
    String M_TYPE_OBJECT_CLASS_AT_OID       = "1.3.6.1.4.1.18060.0.4.0.2.8 ";
    
    String M_SUP_ATTRIBUTE_TYPE_AT          = "m-supAttributeType";
    String M_SUP_ATTRIBUTE_TYPE_AT_OID      = "1.3.6.1.4.1.18060.0.4.0.2.10";

    String M_EQUALITY_AT                    = "m-equality";
    String M_EQUALITY_AT_OID                = "1.3.6.1.4.1.18060.0.4.0.2.11";

    String M_ORDERING_AT                    = "m-ordering";
    String M_ORDERING_AT_OID                = "1.3.6.1.4.1.18060.0.4.0.2.12";

    String M_SUBSTR_AT                      = "m-substr";
    String M_SUBSTR_AT_OID                  = "1.3.6.1.4.1.18060.0.4.0.2.13";

    String M_SYNTAX_AT                      = "m-syntax";
    String M_SYNTAX_AT_OID                  = "1.3.6.1.4.1.18060.0.4.0.2.14";

    String M_SINGLE_VALUE_AT                = "m-singleValue";
    String M_SINGLE_VALUE_AT_OID            = "1.3.6.1.4.1.18060.0.4.0.2.15";
    
    String M_COLLECTIVE_AT                  = "m-collective";
    String M_COLLECTIVE_AT_OID              = "1.3.6.1.4.1.18060.0.4.0.2.16";

    String M_NO_USER_MODIFICATION_AT        = "m-noUserModification";
    String M_NO_USER_MODIFICATION_AT_OID    = "1.3.6.1.4.1.18060.0.4.0.2.17";

    String M_USAGE_AT                       = "m-usage";
    String M_USAGE_AT_OID                   = "1.3.6.1.4.1.18060.0.4.0.2.18";
    
    String M_RULE_ID_AT                     = "m-ruleId";
    String M_RULE_ID_AT_OID                 = "1.3.6.1.4.1.18060.0.4.0.2.20";
    
    String M_FORM_AT                        = "m-form";
    String M_FORM_AT_OID                    = "1.3.6.1.4.1.18060.0.4.0.2.21";
    
    String M_SUP_DIT_STRUCTURE_RULE_AT      = "m-supDITStructureRule";
    String M_SUP_DIT_STRUCTURE_RULE_AT_OID  = "1.3.6.1.4.1.18060.0.4.0.2.22";

    String M_OC_AT                          = "m-oc";
    String M_OC_AT_OID                      = "1.3.6.1.4.1.18060.0.4.0.2.24";
    
    String M_AUX_AT                         = "m-aux";
    String M_AUX_AT_OID                     = "1.3.6.1.4.1.18060.0.4.0.2.26";

    String M_NOT_AT                         = "m-not";
    String M_NOT_AT_OID                     = "1.3.6.1.4.1.18060.0.4.0.2.27";
    
    String M_APPLIES_AT                     = "m-applies";
    String M_APPLIES_AT_OID                 = "1.3.6.1.4.1.18060.0.4.0.2.29";
    
    String M_MATCHING_RULE_SYNTAX_AT        = "m-matchingRuleSyntax";
    String M_MATCHING_RULE_SYNTAX_AT_OID    = "1.3.6.1.4.1.18060.0.4.0.2.31";

    String M_FQCN_AT                        = "m-fqcn";
    String M_FQCN_AT_OID                    = "1.3.6.1.4.1.18060.0.4.0.2.32";

    String M_BYTECODE_AT                    = "m-bytecode";
    String M_BYTECODE_AT_OID                = "1.3.6.1.4.1.18060.0.4.0.2.33";
    
    String X_HUMAN_READABLE_AT              = "x-humanReadable";
    String X_HUMAN_READABLE_AT_OID          = "1.3.6.1.4.1.18060.0.4.0.2.34";

    String M_DISABLED_AT                    = "m-disabled";
    String M_DISABLED_AT_OID                = "1.3.6.1.4.1.18060.0.4.0.2.37";

    String M_DEPENDENCIES_AT                = "m-dependencies";
    String M_DEPENDENCIES_AT_OID            = "1.3.6.1.4.1.18060.0.4.0.2.38";
    
    String M_LENGTH_AT                      = "m-length";
    String M_LENGTH_AT_OID                  = "1.3.6.1.4.1.18060.0.4.0.2.39";
    
    // -- schema extensions & values --
    String X_SCHEMA                         = "X-SCHEMA";
    String X_IS_HUMAN_READABLE              = "X-IS-HUMAN-READABLE";
    String X_READ_ONLY                      = "X-READ-ONLY";
    String X_ENABLED                        = "X-ENABLED";
}
