/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.camel.BatchConsumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOnCompletion;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericFileConsumer<T>
extends ScheduledPollConsumer
implements BatchConsumer {
    protected final transient Log log = LogFactory.getLog(this.getClass());
    protected GenericFileEndpoint<T> endpoint;
    protected GenericFileOperations<T> operations;
    protected boolean loggedIn;
    protected String fileExpressionResult;
    protected int maxMessagesPerPoll;

    public GenericFileConsumer(GenericFileEndpoint<T> endpoint, Processor processor, GenericFileOperations<T> operations) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.operations = operations;
    }

    @Override
    protected void poll() throws Exception {
        int total;
        this.fileExpressionResult = null;
        if (!this.prePollCheck()) {
            this.log.debug((Object)"Skipping pool as pre poll check returned false");
        }
        ArrayList<GenericFile<T>> files = new ArrayList<GenericFile<T>>();
        String name = this.endpoint.getConfiguration().getDirectory();
        this.pollDirectory(name, files);
        if (this.endpoint.getSorter() != null) {
            Collections.sort(files, this.endpoint.getSorter());
        }
        LinkedList<Exchange> exchanges = new LinkedList<Exchange>();
        for (GenericFile genericFile : files) {
            Exchange exchange = this.endpoint.createExchange(genericFile);
            this.endpoint.configureMessage(genericFile, exchange.getIn());
            exchanges.add(exchange);
        }
        if (this.endpoint.getSortBy() != null) {
            Collections.sort(exchanges, this.endpoint.getSortBy());
        }
        if ((total = exchanges.size()) > 0 && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Total " + total + " files to consume"));
        }
        LinkedList<Exchange> linkedList = exchanges;
        this.processBatch(CastUtils.cast(linkedList));
    }

    @Override
    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    @Override
    public void processBatch(Queue<Object> exchanges) {
        int total = exchanges.size();
        if (this.maxMessagesPerPoll > 0 && total > this.maxMessagesPerPoll) {
            this.log.debug((Object)("Limiting to maximum messages to poll " + this.maxMessagesPerPoll + " as there was " + total + " messages in this poll."));
            total = this.maxMessagesPerPoll;
        }
        for (int index = 0; index < total && this.isRunAllowed(); ++index) {
            Exchange exchange = (Exchange)exchanges.poll();
            exchange.setProperty("CamelBatchIndex", index);
            exchange.setProperty("CamelBatchSize", total);
            exchange.setProperty("CamelBatchComplete", index == total - 1);
            this.processExchange(exchange);
        }
        while (exchanges.size() > 0) {
            Exchange exchange = (Exchange)exchanges.poll();
            GenericFile file = (GenericFile)exchange.getProperty("CamelFileExchangeFile");
            String key = file.getFileName();
            this.endpoint.getInProgressRepository().remove(key);
        }
    }

    protected boolean prePollCheck() throws Exception {
        return true;
    }

    protected abstract void pollDirectory(String var1, List<GenericFile<T>> var2);

    protected void processExchange(Exchange exchange) {
        GenericFile<T> file = this.getExchangeFileProperty(exchange);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Processing remote file: " + file));
        }
        try {
            GenericFileProcessStrategy<T> processStrategy = this.endpoint.getGenericFileProcessStrategy();
            boolean begin = processStrategy.begin(this.operations, this.endpoint, exchange, file);
            if (!begin) {
                this.log.debug((Object)(this.endpoint + " cannot begin processing file: " + file));
                this.endpoint.getInProgressRepository().remove(file.getFileName());
                return;
            }
            GenericFile<T> target = this.getExchangeFileProperty(exchange);
            String name = target.getAbsoluteFilePath();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Retreiving file: " + name + " from: " + this.endpoint));
            }
            this.operations.retrieveFile(name, exchange);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Retrieved file: " + name + " from: " + this.endpoint));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("About to process file: " + target + " using exchange: " + exchange));
            }
            String originalFileName = file.getFileName();
            exchange.addOnCompletion(new GenericFileOnCompletion<T>(this.endpoint, this.operations, target, originalFileName));
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected boolean isValidFile(GenericFile<T> file, boolean isDirectory) {
        if (!this.isMatched(file, isDirectory)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("File did not match. Will skip this file: " + file));
            }
            return false;
        }
        if (this.endpoint.isIdempotent().booleanValue() && this.endpoint.getIdempotentRepository().contains(file.getFileName())) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("This consumer is idempotent and the file has been consumed before. Will skip this file: " + file));
            }
            return false;
        }
        return true;
    }

    protected boolean isMatched(GenericFile<T> file, boolean isDirectory) {
        String name = file.getFileNameOnly();
        if (name.startsWith(".")) {
            return false;
        }
        if (name.endsWith(".camelLock")) {
            return false;
        }
        if (isDirectory) {
            return true;
        }
        if (this.endpoint.getFilter() != null && !this.endpoint.getFilter().accept(file)) {
            return false;
        }
        if (ObjectHelper.isNotEmpty(this.endpoint.getExclude()) && name.matches(this.endpoint.getExclude())) {
            return false;
        }
        if (ObjectHelper.isNotEmpty(this.endpoint.getInclude()) && !name.matches(this.endpoint.getInclude())) {
            return false;
        }
        if (this.endpoint.getFileName() != null) {
            this.evaluteFileExpression();
            if (this.fileExpressionResult != null && !name.equals(this.fileExpressionResult)) {
                return false;
            }
        }
        return true;
    }

    protected boolean isInProgress(GenericFile<T> file) {
        String key = file.getFileName();
        return !this.endpoint.getInProgressRepository().add(key);
    }

    private void evaluteFileExpression() {
        if (this.fileExpressionResult == null) {
            DefaultExchange dummy = new DefaultExchange(this.endpoint.getCamelContext());
            this.fileExpressionResult = this.endpoint.getFileName().evaluate(dummy, String.class);
        }
    }

    private GenericFile<T> getExchangeFileProperty(Exchange exchange) {
        return (GenericFile)exchange.getProperty("CamelFileExchangeFile");
    }
}

