/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.FallbackConverter;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.bean.BeanInvocation;
import org.apache.camel.spi.TypeConverterRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Converter
public final class BeanConverter {
    private BeanConverter() {
    }

    @FallbackConverter
    public static Object convertTo(Class<?> type, Exchange exchange, Object value, TypeConverterRegistry registry) {
        if (BeanInvocation.class.isAssignableFrom(value.getClass())) {
            BeanInvocation bi = (BeanInvocation)value;
            if (bi.getArgs() == null || bi.getArgs().length != 1) {
                return null;
            }
            Class<?> from = bi.getArgs()[0].getClass();
            Object body = bi.getArgs()[0];
            if (from.isAssignableFrom(type)) {
                return body;
            }
            TypeConverter tc = registry.lookup(type, from);
            if (tc != null) {
                return tc.convertTo(type, exchange, body);
            }
        }
        return null;
    }
}

